/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.RandomAccess;
import tech.oxfordsemantic.jrdfox.logic.LogicObject;
import tech.oxfordsemantic.jrdfox.util.ImmutableArrayList;

public class InterningManager {
    protected static final int INITIAL_NUMBER_OF_ENTRIES = 64;
    protected static final double LOAD_FACTOR = 0.75;
    public static final InterningManager s_instance = new InterningManager();
    protected final ReferenceQueue<InternedObject> m_referenceQueue = new ReferenceQueue();
    protected Entry[] m_entries = new Entry[64];
    protected int m_entriesLengthMinusOne = this.m_entries.length - 1;
    protected int m_size = 0;
    protected int m_resizeThreshold = (int)((double)this.m_entries.length * 0.75);

    public InterningManager() {
        new ReaperThread().start();
    }

    protected final void resizeIfNeeded() {
        int n;
        if (this.m_size > this.m_resizeThreshold) {
            n = this.m_entries.length * 2;
        } else if (this.m_size <= 48 && this.m_entriesLengthMinusOne > 63) {
            n = 64;
        } else {
            return;
        }
        Entry[] entryArray = new Entry[n];
        int n2 = n - 1;
        for (int i = 0; i < this.m_entries.length; ++i) {
            Entry entry = this.m_entries[i];
            while (entry != null) {
                Entry entry2 = entry.m_next;
                if (entry.get() == null) {
                    --this.m_size;
                } else {
                    int n3 = entry.m_hashCode & n2;
                    entry.m_next = entryArray[n3];
                    entryArray[n3] = entry;
                }
                entry = entry2;
            }
        }
        this.m_entries = entryArray;
        this.m_entriesLengthMinusOne = n2;
        this.m_resizeThreshold = (int)((double)n * 0.75);
    }

    public final synchronized <O extends InternedObject, A1> O intern(int n, Class<O> clazz, Creator creator, A1 A1) {
        InternedObject internedObject;
        int n2 = n & this.m_entriesLengthMinusOne;
        Entry entry = null;
        Entry entry2 = this.m_entries[n2];
        while (entry2 != null) {
            if (n == entry2.m_hashCode) {
                internedObject = (InternedObject)entry2.get();
                if (internedObject == null) {
                    if (entry == null) {
                        this.m_entries[n2] = entry2.m_next;
                    } else {
                        entry.m_next = entry2.m_next;
                    }
                    --this.m_size;
                } else if (internedObject.interningEquals(clazz, A1)) {
                    return (O)internedObject;
                }
            }
            entry = entry2;
            entry2 = entry2.m_next;
        }
        internedObject = creator.create(A1);
        this.m_entries[n2] = new Entry(internedObject, this.m_referenceQueue, n, this.m_entries[n2]);
        ++this.m_size;
        this.resizeIfNeeded();
        return (O)internedObject;
    }

    public final synchronized <O extends InternedObject, A1, A2> O intern(int n, Class<O> clazz, Creator creator, A1 A1, A2 A2) {
        InternedObject internedObject;
        int n2 = n & this.m_entriesLengthMinusOne;
        Entry entry = null;
        Entry entry2 = this.m_entries[n2];
        while (entry2 != null) {
            if (n == entry2.m_hashCode) {
                internedObject = (InternedObject)entry2.get();
                if (internedObject == null) {
                    if (entry == null) {
                        this.m_entries[n2] = entry2.m_next;
                    } else {
                        entry.m_next = entry2.m_next;
                    }
                    --this.m_size;
                } else if (internedObject.interningEquals(clazz, A1, A2)) {
                    return (O)internedObject;
                }
            }
            entry = entry2;
            entry2 = entry2.m_next;
        }
        internedObject = creator.create(A1, A2);
        this.m_entries[n2] = new Entry(internedObject, this.m_referenceQueue, n, this.m_entries[n2]);
        ++this.m_size;
        this.resizeIfNeeded();
        return (O)internedObject;
    }

    public final synchronized <O extends InternedObject, A1, A2, A3> O intern(int n, Class<O> clazz, Creator creator, A1 A1, A2 A2, A3 A3) {
        InternedObject internedObject;
        int n2 = n & this.m_entriesLengthMinusOne;
        Entry entry = null;
        Entry entry2 = this.m_entries[n2];
        while (entry2 != null) {
            if (n == entry2.m_hashCode) {
                internedObject = (InternedObject)entry2.get();
                if (internedObject == null) {
                    if (entry == null) {
                        this.m_entries[n2] = entry2.m_next;
                    } else {
                        entry.m_next = entry2.m_next;
                    }
                    --this.m_size;
                } else if (internedObject.interningEquals(clazz, A1, A2, A3)) {
                    return (O)internedObject;
                }
            }
            entry = entry2;
            entry2 = entry2.m_next;
        }
        internedObject = creator.create(A1, A2, A3);
        this.m_entries[n2] = new Entry(internedObject, this.m_referenceQueue, n, this.m_entries[n2]);
        ++this.m_size;
        this.resizeIfNeeded();
        return (O)internedObject;
    }

    public final synchronized <O extends InternedObject, A1, A2, A3, A4> O intern(int n, Class<O> clazz, Creator creator, A1 A1, A2 A2, A3 A3, A4 A4) {
        InternedObject internedObject;
        int n2 = n & this.m_entriesLengthMinusOne;
        Entry entry = null;
        Entry entry2 = this.m_entries[n2];
        while (entry2 != null) {
            if (n == entry2.m_hashCode) {
                internedObject = (InternedObject)entry2.get();
                if (internedObject == null) {
                    if (entry == null) {
                        this.m_entries[n2] = entry2.m_next;
                    } else {
                        entry.m_next = entry2.m_next;
                    }
                    --this.m_size;
                } else if (internedObject.interningEquals(clazz, A1, A2, A3, A4)) {
                    return (O)internedObject;
                }
            }
            entry = entry2;
            entry2 = entry2.m_next;
        }
        internedObject = creator.create(A1, A2, A3, A4);
        this.m_entries[n2] = new Entry(internedObject, this.m_referenceQueue, n, this.m_entries[n2]);
        ++this.m_size;
        this.resizeIfNeeded();
        return (O)internedObject;
    }

    public final synchronized <O extends InternedObject, A1, A2, A3, A4, A5> O intern(int n, Class<O> clazz, Creator creator, A1 A1, A2 A2, A3 A3, A4 A4, A5 A5) {
        InternedObject internedObject;
        int n2 = n & this.m_entriesLengthMinusOne;
        Entry entry = null;
        Entry entry2 = this.m_entries[n2];
        while (entry2 != null) {
            if (n == entry2.m_hashCode) {
                internedObject = (InternedObject)entry2.get();
                if (internedObject == null) {
                    if (entry == null) {
                        this.m_entries[n2] = entry2.m_next;
                    } else {
                        entry.m_next = entry2.m_next;
                    }
                    --this.m_size;
                } else if (internedObject.interningEquals(clazz, A1, A2, A3, A4, A5)) {
                    return (O)internedObject;
                }
            }
            entry = entry2;
            entry2 = entry2.m_next;
        }
        internedObject = creator.create(A1, A2, A3, A4, A5);
        this.m_entries[n2] = new Entry(internedObject, this.m_referenceQueue, n, this.m_entries[n2]);
        ++this.m_size;
        this.resizeIfNeeded();
        return (O)internedObject;
    }

    public final synchronized <O extends InternedObject, A1, A2, A3, A4, A5, A6> O intern(int n, Class<O> clazz, Creator creator, A1 A1, A2 A2, A3 A3, A4 A4, A5 A5, A6 A6) {
        InternedObject internedObject;
        int n2 = n & this.m_entriesLengthMinusOne;
        Entry entry = null;
        Entry entry2 = this.m_entries[n2];
        while (entry2 != null) {
            if (n == entry2.m_hashCode) {
                internedObject = (InternedObject)entry2.get();
                if (internedObject == null) {
                    if (entry == null) {
                        this.m_entries[n2] = entry2.m_next;
                    } else {
                        entry.m_next = entry2.m_next;
                    }
                    --this.m_size;
                } else if (internedObject.interningEquals(clazz, A1, A2, A3, A4, A5, A6)) {
                    return (O)internedObject;
                }
            }
            entry = entry2;
            entry2 = entry2.m_next;
        }
        internedObject = creator.create(A1, A2, A3, A4, A5, A6);
        this.m_entries[n2] = new Entry(internedObject, this.m_referenceQueue, n, this.m_entries[n2]);
        ++this.m_size;
        this.resizeIfNeeded();
        return (O)internedObject;
    }

    protected static class Entry
    extends WeakReference<InternedObject> {
        public final int m_hashCode;
        public Entry m_next;

        public Entry(InternedObject internedObject, ReferenceQueue<InternedObject> referenceQueue, int n, Entry entry) {
            super(internedObject, referenceQueue);
            this.m_hashCode = n;
            this.m_next = entry;
        }
    }

    protected class ReaperThread
    extends Thread {
        public ReaperThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Entry entry = (Entry)InterningManager.this.m_referenceQueue.remove();
                        InterningManager interningManager = InterningManager.this;
                        synchronized (interningManager) {
                            block6: do {
                                int n = entry.m_hashCode & InterningManager.this.m_entriesLengthMinusOne;
                                Entry entry2 = null;
                                Entry entry3 = InterningManager.this.m_entries[n];
                                while (entry3 != null) {
                                    if (entry3 == entry) {
                                        --InterningManager.this.m_size;
                                        if (entry2 == null) {
                                            InterningManager.this.m_entries[n] = entry3.m_next;
                                            continue block6;
                                        }
                                        entry2.m_next = entry3.m_next;
                                        continue block6;
                                    }
                                    entry2 = entry3;
                                    entry3 = entry3.m_next;
                                }
                            } while ((entry = (Entry)InterningManager.this.m_referenceQueue.poll()) != null);
                            InterningManager.this.resizeIfNeeded();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static abstract class InternedObject {
        protected boolean interningEquals(Class<?> clazz, Object object) {
            return false;
        }

        protected boolean interningEquals(Class<?> clazz, Object object, Object object2) {
            return false;
        }

        protected boolean interningEquals(Class<?> clazz, Object object, Object object2, Object object3) {
            return false;
        }

        protected boolean interningEquals(Class<?> clazz, Object object, Object object2, Object object3, Object object4) {
            return false;
        }

        protected boolean interningEquals(Class<?> clazz, Object object, Object object2, Object object3, Object object4, Object object5) {
            return false;
        }

        protected boolean interningEquals(Class<?> clazz, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
            return false;
        }

        protected static <E> int hashCode(List<E> list) {
            int n = 1;
            if (list instanceof RandomAccess) {
                int n2 = list.size();
                for (int i = 0; i < n2; ++i) {
                    n = 31 * n + list.get(i).hashCode();
                }
            } else {
                for (E e : list) {
                    n = 31 * n + e.hashCode();
                }
            }
            return n;
        }

        protected static int hashCode(int n, int n2) {
            return n + n2;
        }

        protected static int hashCode(int n, int n2, int n3) {
            return (n + n2) * 31 + n3;
        }

        protected static int hashCode(int n, int n2, int n3, int n4) {
            return ((n + n2) * 31 + n3) * 31 + n4;
        }

        protected static int hashCode(int n, int n2, int n3, int n4, int n5) {
            return ((n + n2) * 31 + n3) * 31 + n4 + n5;
        }

        protected static int hashCode(int n, int n2, int n3, int n4, int n5, int n6) {
            return (((n + n2) * 31 + n3) * 31 + n4 + n5) * 31 + n6;
        }

        protected static int hashCode(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            return ((((n + n2) * 31 + n3) * 31 + n4 + n5) * 31 + n6) * 31 + n7;
        }

        protected static int hashCode(int n, Object object) {
            return InternedObject.hashCode(n, object.hashCode());
        }

        protected static int hashCode(int n, Object object, Object object2) {
            return InternedObject.hashCode(n, object.hashCode(), object2.hashCode());
        }

        protected static int hashCode(int n, Object object, Object object2, Object object3) {
            return InternedObject.hashCode(n, object.hashCode(), object2.hashCode(), object3.hashCode());
        }

        protected static int hashCode(int n, Object object, Object object2, Object object3, Object object4) {
            return InternedObject.hashCode(n, object.hashCode(), object2.hashCode(), object3.hashCode(), object4.hashCode());
        }

        protected static <E extends LogicObject> boolean flatEquals(ImmutableArrayList<E> immutableArrayList, Object object) {
            return InternedObject.flatEquals(immutableArrayList, (List)object);
        }

        protected static <E extends LogicObject> boolean flatEquals(ImmutableArrayList<E> immutableArrayList, List<E> list) {
            if (((LogicObject[])immutableArrayList.m_elements).length != list.size()) {
                return false;
            }
            return InternedObject.flatEqualsNoSizeCheck((LogicObject[])((LogicObject[])immutableArrayList.m_elements), list);
        }

        protected static <E extends LogicObject> boolean flatEqualsNoSizeCheck(E[] EArray, List<E> list) {
            if (list instanceof RandomAccess) {
                for (int i = EArray.length - 1; i >= 0; --i) {
                    if (EArray[i] == list.get(i)) continue;
                    return false;
                }
            } else {
                int n = 0;
                for (LogicObject logicObject : list) {
                    if (EArray[n] == logicObject) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static abstract class Creator {
        protected InternedObject create(Object object) {
            return null;
        }

        protected InternedObject create(Object object, Object object2) {
            return null;
        }

        protected InternedObject create(Object object, Object object2, Object object3) {
            return null;
        }

        protected InternedObject create(Object object, Object object2, Object object3, Object object4) {
            return null;
        }

        protected InternedObject create(Object object, Object object2, Object object3, Object object4, Object object5) {
            return null;
        }

        protected InternedObject create(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
            return null;
        }
    }
}

