/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic.datalog;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.exceptions.JRDFoxException;
import tech.oxfordsemantic.jrdfox.formats.DatalogParser;
import tech.oxfordsemantic.jrdfox.logic.LogicObject;
import tech.oxfordsemantic.jrdfox.logic.LogicVisitor;
import tech.oxfordsemantic.jrdfox.logic.datalog.BodyFormula;
import tech.oxfordsemantic.jrdfox.logic.datalog.TupleTableAtom;
import tech.oxfordsemantic.jrdfox.logic.expression.Literal;
import tech.oxfordsemantic.jrdfox.util.ImmutableArrayList;
import tech.oxfordsemantic.jrdfox.util.InterningManager;

public class Rule
extends LogicObject {
    protected final ImmutableArrayList<TupleTableAtom> m_head;
    protected final ImmutableArrayList<BodyFormula> m_body;
    private static final long serialVersionUID = -6711064904912515288L;
    protected static final int s_classHashCodeTimes31 = 31 * Rule.class.hashCode();
    protected static InterningManager.Creator s_creator = new InterningManager.Creator(){

        @Override
        public InterningManager.InternedObject create(Object object, Object object2) {
            return new Rule((List)object, (List)object2);
        }
    };

    protected Rule(List<TupleTableAtom> list, List<BodyFormula> list2) {
        this.m_head = ImmutableArrayList.create(list, TupleTableAtom.EMPTY_ARRAY);
        this.m_body = ImmutableArrayList.create(list2, BodyFormula.EMPTY_ARRAY);
    }

    public List<TupleTableAtom> getHead() {
        return this.m_head;
    }

    public List<BodyFormula> getBody() {
        return this.m_body;
    }

    @Override
    public <E> E accept(LogicVisitor<E> logicVisitor) {
        return logicVisitor.visit(this);
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer) {
        int n;
        for (n = 0; n < ((TupleTableAtom[])this.m_head.m_elements).length; ++n) {
            if (n != 0) {
                consumer.accept(", ");
            }
            ((TupleTableAtom[])this.m_head.m_elements)[n].toString(prefixes, consumer);
        }
        consumer.accept(" :- ");
        for (n = 0; n < ((BodyFormula[])this.m_body.m_elements).length; ++n) {
            if (n != 0) {
                consumer.accept(", ");
            }
            ((BodyFormula[])this.m_body.m_elements)[n].toString(prefixes, consumer);
        }
        consumer.accept(".");
    }

    public static Rule create(List<TupleTableAtom> list, List<BodyFormula> list2) {
        return InterningManager.s_instance.intern(Rule.hashCode(s_classHashCodeTimes31, Rule.hashCode(list), Rule.hashCode(list2)), Rule.class, s_creator, list, list2);
    }

    public static Rule create(TupleTableAtom tupleTableAtom, List<BodyFormula> list) {
        return Rule.create(Arrays.asList(tupleTableAtom), list);
    }

    public static Rule create(TupleTableAtom tupleTableAtom, BodyFormula ... bodyFormulaArray) {
        return Rule.create(Arrays.asList(tupleTableAtom), Arrays.asList(bodyFormulaArray));
    }

    public static Rule create(TupleTableAtom[] tupleTableAtomArray, BodyFormula[] bodyFormulaArray) {
        return Rule.create(Arrays.asList(tupleTableAtomArray), Arrays.asList(bodyFormulaArray));
    }

    public static Rule parse(Prefixes prefixes, String string) throws JRDFoxException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        try {
            DatalogParser datalogParser = new DatalogParser(Literal.UNDEF, prefixes);
            datalogParser.bind(byteArrayInputStream);
            return datalogParser.parseRule();
        }
        catch (IOException iOException) {
            throw new JRDFoxException("Error parsing rule: " + string, iOException);
        }
    }

    @Override
    protected boolean interningEquals(Class<?> clazz, Object object, Object object2) {
        return clazz == Rule.class && Rule.flatEquals(this.m_head, object) && Rule.flatEquals(this.m_body, object2);
    }

    protected Object readResolve() {
        return Rule.create(this.m_head, this.m_body);
    }
}

