/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.formats.internal;

import java.io.IOException;
import java.io.InputStream;
import tech.oxfordsemantic.jrdfox.formats.internal.InputSource;

public class UTF8InputSource
extends InputSource {
    protected final InputStream m_inputStream;

    public UTF8InputSource(InputStream inputStream) {
        this.m_inputStream = inputStream;
    }

    @Override
    protected final int readNextCodePoint() throws IOException {
        int n = this.m_inputStream.read();
        if ((n & 0x80) == 0) {
            return n;
        }
        if ((n & 0xE0) == 192) {
            int n2 = this.m_inputStream.read();
            if ((n2 & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 encoding in the input.");
            }
            int n3 = (n & 0x1F) << 6 | n2 & 0x3F;
            if (n3 < 128) {
                throw new IOException("Invalid UTF-8 encoding in the input.");
            }
            return n3;
        }
        if ((n & 0xF0) == 224) {
            int n4 = this.m_inputStream.read();
            int n5 = this.m_inputStream.read();
            if ((n4 & 0xC0) != 128 || (n5 & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 encoding in the input.");
            }
            int n6 = (n & 0xF) << 12 | (n4 & 0x3F) << 6 | n5 & 0x3F;
            if (n6 < 2048 || 55295 < n6 && n6 < 57344) {
                throw new IOException("Invalid UTF-8 encoding in the input.");
            }
            return n6;
        }
        if ((n & 0xF8) == 240) {
            int n7 = this.m_inputStream.read();
            int n8 = this.m_inputStream.read();
            int n9 = this.m_inputStream.read();
            if ((n7 & 0xC0) != 128 || (n8 & 0xC0) != 128 || (n9 & 0xC0) != 128) {
                throw new IOException("Invalid UTF-8 encoding in the input.");
            }
            int n10 = (n & 7) << 18 | (n7 & 0x3F) << 12 | (n8 & 0x3F) << 6 | n9 & 0x3F;
            if (n10 < 65536 || 0x10FFFF < n10) {
                throw new IOException("Invalid UTF-8 encoding in the input.");
            }
            return n10;
        }
        if (n == -1) {
            return -1;
        }
        throw new IOException("Invalid UTF-8 encoding in the input.");
    }
}

