/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import tech.oxfordsemantic.jrdfox.client.DataStoreConnection;
import tech.oxfordsemantic.jrdfox.client.ServerConnection;
import tech.oxfordsemantic.jrdfox.exceptions.JRDFoxException;
import tech.oxfordsemantic.jrdfox.local.LocalServer;

public class RDFoxServer {
    private static boolean s_nativeRDFoxLibraryLoaded = false;
    private static boolean s_serverStarted = false;
    private static boolean s_endpointStarted = false;

    public static synchronized void loadRDFoxNativeLibraryFromAbsolutePath(String string) {
        if (!s_nativeRDFoxLibraryLoaded) {
            System.load(string);
            s_nativeRDFoxLibraryLoaded = true;
        }
    }

    public static synchronized void loadRDFoxNativeLibraryFromDefaultPath(String string) {
        if (!s_nativeRDFoxLibraryLoaded) {
            System.loadLibrary(string);
            s_nativeRDFoxLibraryLoaded = true;
        }
    }

    public static synchronized ServerConnection newServerConnection(String string, String string2) throws JRDFoxException {
        if (!s_serverStarted) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if ("true".equals(System.getProperty("RDFox.api-log"))) {
                String string3;
                hashMap.put("api-log", "true");
                String string4 = System.getProperty("RDFox.api-log.directory");
                if (string4 != null) {
                    hashMap.put("api-log.directory", string4);
                }
                if ((string3 = System.getProperty("RDFox.api-log.input-recording-limit")) != null) {
                    hashMap.put("api-log.input-recording-limit", string3);
                }
            }
            RDFoxServer.start(hashMap);
            if (RDFoxServer.getNumberOfRoles() == 0L) {
                RDFoxServer.createFirstRole(string, string2);
            }
        }
        return LocalServer.newServerConnection(string, string2);
    }

    public static synchronized DataStoreConnection newDataStoreConnection(String string, String string2, String string3) throws JRDFoxException {
        if (!s_serverStarted) {
            throw new JRDFoxException("The server instance has not been started.");
        }
        return LocalServer.newDataStoreConnection(string, string2, string3);
    }

    public static synchronized InstanceState analyzeState(String string) throws JRDFoxException {
        RDFoxServer.ensureRDFoxNativeLibraryLoaded();
        return InstanceState.values()[LocalServer.analyzeState(string)];
    }

    public static synchronized void initialize(String string, String string2, Map<String, String> map) throws JRDFoxException {
        RDFoxServer.ensureRDFoxNativeLibraryLoaded();
        LocalServer.initialize(string, string2, map);
    }

    public static synchronized void upgrade(String string, String string2, OutputStream outputStream) throws JRDFoxException {
        RDFoxServer.ensureRDFoxNativeLibraryLoaded();
        LocalServer.upgrade(string, string2, outputStream);
    }

    public static synchronized int start(Map<String, String> map) throws JRDFoxException {
        if (s_serverStarted) {
            return -1;
        }
        RDFoxServer.ensureRDFoxNativeLibraryLoaded();
        int n = LocalServer.startServer(map);
        s_serverStarted = true;
        return n;
    }

    public static synchronized long getNumberOfRoles() throws JRDFoxException {
        if (!s_serverStarted) {
            throw new JRDFoxException("A server instance has not been started.");
        }
        return LocalServer.getNumberOfRoles();
    }

    public static synchronized void createFirstRole(String string, String string2) throws JRDFoxException {
        if (!s_serverStarted) {
            throw new JRDFoxException("A server instance has not been started.");
        }
        LocalServer.createFirstRole(string, string2);
    }

    public static synchronized void stop() throws JRDFoxException {
        if (s_serverStarted) {
            if (s_endpointStarted) {
                LocalServer.stopEndpoint();
                s_endpointStarted = false;
            }
            LocalServer.stopServer();
            s_serverStarted = false;
        }
    }

    public static synchronized boolean startEndpoint(Map<String, String> map) throws JRDFoxException {
        if (!s_serverStarted) {
            throw new JRDFoxException("The server must be started before the endpoint can be started.");
        }
        if (!s_endpointStarted) {
            LocalServer.startEndpoint(map);
            s_endpointStarted = true;
            return true;
        }
        return false;
    }

    public static synchronized void stopEndpoint() throws JRDFoxException {
        if (s_endpointStarted) {
            LocalServer.stopEndpoint();
            s_endpointStarted = false;
        }
    }

    private static synchronized void ensureRDFoxNativeLibraryLoaded() throws JRDFoxException {
        if (!s_nativeRDFoxLibraryLoaded) {
            String string;
            block19: {
                String string2;
                String string3;
                String string4 = System.getProperty("os.name").toLowerCase();
                if (string4.contains("win")) {
                    string = "libRDFox";
                    string3 = "win64";
                    string2 = ".dll";
                } else {
                    string = "RDFox";
                    if (string4.contains("mac")) {
                        string3 = "macOS";
                        string2 = ".dylib";
                    } else {
                        string3 = "linux";
                        string2 = ".so";
                    }
                }
                try (InputStream inputStream = LocalServer.class.getResourceAsStream("/tech/oxfordsemantic/jrdfox/lib-" + string3 + "/libRDFox" + string2);){
                    File file;
                    if (inputStream == null || !(file = File.createTempFile("libRDFox", string2)).exists()) break block19;
                    file.deleteOnExit();
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        int n;
                        byte[] byArray = new byte[1024];
                        while ((n = inputStream.read(byArray)) != -1) {
                            ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        }
                    }
                    System.load(file.getAbsolutePath());
                    s_nativeRDFoxLibraryLoaded = true;
                    return;
                }
                catch (IOException iOException) {
                    throw new JRDFoxException("The native RDFox library could not be loaded.", iOException);
                }
            }
            System.loadLibrary(string);
            s_nativeRDFoxLibraryLoaded = true;
        }
    }

    public static enum InstanceState {
        UNINITIALIZED,
        REQUIRES_UPGRADE,
        READY;

    }
}

