/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic.expression;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.logic.LogicVisitor;
import tech.oxfordsemantic.jrdfox.logic.expression.Individual;
import tech.oxfordsemantic.jrdfox.util.InterningManager;

public class IRI
extends Individual {
    protected final String m_IRIPrefix;
    protected final String m_IRIRest;
    private static final long serialVersionUID = 2945660301348912654L;
    protected static ConcurrentHashMap<String, String> s_IRIPrefixes = new ConcurrentHashMap();
    protected static final int s_classHashCodeTimes31 = 31 * IRI.class.hashCode();
    protected static InterningManager.Creator s_creator = new InterningManager.Creator(){

        @Override
        public InterningManager.InternedObject create(Object object, Object object2) {
            return new IRI((String)object, (String)object2);
        }
    };
    public static final IRI RDF_TYPE = IRI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    public static final IRI RDF_FIRST = IRI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
    public static final IRI RDF_REST = IRI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
    public static final IRI RDF_NIL = IRI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
    public static final IRI THING = IRI.create("http://www.w3.org/2002/07/owl#Thing");
    public static final IRI NOTHING = IRI.create("http://www.w3.org/2002/07/owl#Nothing");
    public static final IRI TOP_OBJECT_PROPERTY = IRI.create("http://www.w3.org/2002/07/owl#topObjectProperty");
    public static final IRI BOTTOM_OBJECT_PROPERTY = IRI.create("http://www.w3.org/2002/07/owl#bottomObjectProperty");
    public static final IRI TOP_DATA_PROPERTY = IRI.create("http://www.w3.org/2002/07/owl#topDataProperty");
    public static final IRI BOTTOM_DATA_PROPERTY = IRI.create("http://www.w3.org/2002/07/owl#bottomDataProperty");
    public static final IRI SAME_AS = IRI.create("http://www.w3.org/2002/07/owl#sameAs");
    public static final IRI DIFFERENT_FROM = IRI.create("http://www.w3.org/2002/07/owl#differentFrom");
    public static final IRI RDFS_LITERAL = IRI.create("http://www.w3.org/2000/01/rdf-schema#Literal");

    protected IRI(String string, String string2) {
        String string3 = s_IRIPrefixes.putIfAbsent(string, string);
        this.m_IRIPrefix = string3 == null ? string : string3;
        this.m_IRIRest = string2;
    }

    public String getIRI() {
        return this.m_IRIPrefix + this.m_IRIRest;
    }

    @Override
    public <E> E accept(LogicVisitor<E> logicVisitor) {
        return logicVisitor.visit(this);
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer) {
        if (this.m_IRIRest.equals("internal:argument-*")) {
            consumer.accept("*");
        } else {
            prefixes.encodeIRI((CharSequence)this.getIRI(), consumer);
        }
    }

    public static IRI create(String string) {
        int n = string.lastIndexOf(35);
        if (n == -1) {
            n = string.lastIndexOf(47);
        }
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1);
        return IRI.create(string2, string3);
    }

    protected static IRI create(String string, String string2) {
        return InterningManager.s_instance.intern(IRI.hashCode(s_classHashCodeTimes31, string, string2), IRI.class, s_creator, string, string2);
    }

    @Override
    protected boolean interningEquals(Class<?> clazz, Object object, Object object2) {
        return clazz == IRI.class && this.m_IRIPrefix.equals(object) && this.m_IRIRest.equals(object2);
    }

    protected Object readResolve() {
        return IRI.create(this.m_IRIPrefix, this.m_IRIRest);
    }
}

