/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic.datalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.logic.LogicVisitor;
import tech.oxfordsemantic.jrdfox.logic.datalog.Atom;
import tech.oxfordsemantic.jrdfox.logic.datalog.BodyFormula;
import tech.oxfordsemantic.jrdfox.logic.expression.FunctionCall;
import tech.oxfordsemantic.jrdfox.logic.expression.Term;
import tech.oxfordsemantic.jrdfox.logic.expression.Variable;
import tech.oxfordsemantic.jrdfox.util.ImmutableArrayList;
import tech.oxfordsemantic.jrdfox.util.ImmutablePair;
import tech.oxfordsemantic.jrdfox.util.InterningManager;

public class Aggregate
extends BodyFormula {
    protected final ImmutableArrayList<Atom> m_aggregatedAtoms;
    protected final ImmutableArrayList<Variable> m_groupVariables;
    protected final ImmutableArrayList<Bind> m_binds;
    private static final long serialVersionUID = 7324234169789312152L;
    protected static final int s_classHashCodeTimes31 = 31 * Aggregate.class.hashCode();
    protected static InterningManager.Creator s_creator = new InterningManager.Creator(){

        @Override
        public InterningManager.InternedObject create(Object object, Object object2, Object object3) {
            return new Aggregate((List)object, (List)object2, (List)object3);
        }
    };

    protected static ImmutableArrayList<Term> getArguments(List<Variable> list, List<Bind> list2) {
        ArrayList<Variable> arrayList = new ArrayList<Variable>(list);
        if (list2 instanceof RandomAccess) {
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add((Variable)((Term)list2.get((int)i).m_second));
            }
        } else {
            for (ImmutablePair immutablePair : list2) {
                arrayList.add((Variable)((Term)immutablePair.m_second));
            }
        }
        return ImmutableArrayList.create(arrayList, Term.EMPTY_ARRAY);
    }

    protected Aggregate(List<Atom> list, List<Variable> list2, List<Bind> list3) {
        super(Aggregate.getArguments(list2, list3));
        this.m_aggregatedAtoms = ImmutableArrayList.create(list, Atom.EMPTY_ARRAY);
        this.m_groupVariables = ImmutableArrayList.create(list2, Variable.EMPTY_ARRAY);
        this.m_binds = ImmutableArrayList.create(list3, Bind.EMPTY_ARRAY);
    }

    public List<Atom> getAggregatedAtoms() {
        return this.m_aggregatedAtoms;
    }

    public List<Variable> getGroupVariables() {
        return this.m_groupVariables;
    }

    public List<Bind> getAggregateBinds() {
        return this.m_binds;
    }

    @Override
    public <E> E accept(LogicVisitor<E> logicVisitor) {
        return logicVisitor.visit(this);
    }

    @Override
    public void toString(Prefixes prefixes, Consumer<String> consumer) {
        int n;
        consumer.accept("AGGREGATE(");
        for (n = 0; n < ((Atom[])this.m_aggregatedAtoms.m_elements).length; ++n) {
            if (n != 0) {
                consumer.accept(", ");
            }
            ((Atom[])this.m_aggregatedAtoms.m_elements)[n].toString(prefixes, consumer);
        }
        consumer.accept(" ON");
        for (n = 0; n < ((Variable[])this.m_groupVariables.m_elements).length; ++n) {
            consumer.accept(" ");
            ((Variable[])this.m_groupVariables.m_elements)[n].toString(prefixes, consumer);
        }
        for (n = 0; n < ((Bind[])this.m_binds.m_elements).length; ++n) {
            Bind bind = ((Bind[])this.m_binds.m_elements)[n];
            consumer.accept(" BIND ");
            ((FunctionCall)bind.m_first).toString(prefixes, consumer);
            consumer.accept(" AS ");
            ((Variable)bind.m_second).toString(prefixes, consumer);
        }
        consumer.accept(")");
    }

    public static Aggregate create(List<Atom> list, List<Variable> list2, List<Bind> list3) {
        return InterningManager.s_instance.intern(Aggregate.hashCode(s_classHashCodeTimes31, Aggregate.hashCode(list), Aggregate.hashCode(list2), Aggregate.hashCode(list3)), Aggregate.class, s_creator, list, list2, list3);
    }

    public static Aggregate create(Atom[] atomArray, Variable[] variableArray, Bind[] bindArray) {
        return Aggregate.create(Arrays.asList(atomArray), Arrays.asList(variableArray), Arrays.asList(bindArray));
    }

    @Override
    protected boolean interningEquals(Class<?> clazz, Object object, Object object2, Object object3) {
        return clazz == Aggregate.class && Aggregate.flatEquals(this.m_aggregatedAtoms, object) && Aggregate.flatEquals(this.m_groupVariables, object2) && this.m_binds.equals(object3);
    }

    protected Object readResolve() {
        return Aggregate.create(this.m_aggregatedAtoms, this.m_groupVariables, this.m_binds);
    }

    public static class Bind
    extends ImmutablePair<FunctionCall, Variable> {
        private static final long serialVersionUID = 9070204359651053379L;
        public static final Bind[] EMPTY_ARRAY = new Bind[0];

        public Bind(FunctionCall functionCall, Variable variable) {
            super(functionCall, variable);
        }
    }
}

