/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.local;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import tech.oxfordsemantic.jrdfox.client.BinaryDataStoreFormat;
import tech.oxfordsemantic.jrdfox.client.ComponentInfo;
import tech.oxfordsemantic.jrdfox.client.DataStoreConnection;
import tech.oxfordsemantic.jrdfox.client.DataStoreInfo;
import tech.oxfordsemantic.jrdfox.client.DataStoreOperationStartMonitor;
import tech.oxfordsemantic.jrdfox.client.OfflineRequestResult;
import tech.oxfordsemantic.jrdfox.client.PasswordSpecificationType;
import tech.oxfordsemantic.jrdfox.client.ServerConnection;
import tech.oxfordsemantic.jrdfox.exceptions.JRDFoxException;
import tech.oxfordsemantic.jrdfox.local.LocalDataStoreConnection;
import tech.oxfordsemantic.jrdfox.local.LocalServer;

public class LocalServerConnection
implements ServerConnection {
    protected long m_serverConnectionPtr;
    protected volatile ServerInfo m_serverInfo;
    protected final AtomicBoolean m_inUse;

    protected static native void nClose(long var0);

    protected static native void nInterrupt(long var0) throws JRDFoxException;

    protected static native String nGetAgentName(long var0) throws JRDFoxException;

    protected static native void nCheckPassword(long var0, String var2) throws JRDFoxException;

    protected static native long nDuplicate(long var0) throws JRDFoxException;

    protected static native String[] nDescribeServer(long var0) throws JRDFoxException;

    protected static native long[] nGetMemoryUse(long var0) throws JRDFoxException;

    protected static native void nSetMaxMemoryUse(long var0, long var2) throws JRDFoxException;

    protected static native int nGetNumberOfThreads(long var0) throws JRDFoxException;

    protected static native void nSetNumberOfThreads(long var0, int var2) throws JRDFoxException;

    protected static native int nGetServerVersion(long var0) throws JRDFoxException;

    protected static native boolean nCheckIntegrity(long var0, int var2, OutputStream var3) throws JRDFoxException;

    protected static native ComponentInfo nGetComponentInfo(long var0, boolean var2) throws JRDFoxException;

    protected static native Map<String, Optional<DataStoreInfo>> nListDataStores(long var0) throws JRDFoxException;

    protected static native boolean nContainsDataStore(long var0, String var2) throws JRDFoxException;

    protected static native DataStoreInfo nDescribeDataStore(long var0, String var2) throws JRDFoxException;

    protected static native void nCreateDataStore(long var0, String var2, String[] var3) throws JRDFoxException;

    protected static native void nLoadDataStoreFromBinaryFormatStream(long var0, String var2, InputStream var3, String var4, String var5, String[] var6) throws JRDFoxException;

    protected static native void nLoadDataStoreFromBinaryFormatFile(long var0, String var2, String var3, String var4, String var5, String[] var6) throws JRDFoxException;

    protected static native void nSaveDataStoreToBinaryFormatStream(long var0, String var2, OutputStream var3, String var4, String var5, int var6, DataStoreOperationStartMonitor var7) throws JRDFoxException;

    protected static native void nSaveDataStoreToBinaryFormatFile(long var0, String var2, String var3, String var4, String var5, int var6, DataStoreOperationStartMonitor var7) throws JRDFoxException;

    protected static native void nDeleteDataStore(long var0, String var2, DataStoreOperationStartMonitor var3) throws JRDFoxException;

    protected static native boolean nIsDataStoreOnline(long var0, String var2) throws JRDFoxException;

    protected static native boolean nBringDataStoreOnline(long var0, String var2) throws JRDFoxException;

    protected static native OfflineRequestResult nBringDataStoreOffline(long var0, String var2) throws JRDFoxException;

    protected static native long nNewDataStoreConnection(long var0, String var2) throws JRDFoxException;

    protected static native String[] nListRoles(long var0) throws JRDFoxException;

    protected static native void nCreateRole(long var0, String var2, int var3, String var4) throws JRDFoxException;

    protected static native void nDeleteRole(long var0, String var2) throws JRDFoxException;

    protected static native void nChangeRolePassword(long var0, String var2, String var3) throws JRDFoxException;

    protected static native String nGetRolePasswordHash(long var0, String var2) throws JRDFoxException;

    protected static native String[] nListRoleMemberships(long var0, String var2) throws JRDFoxException;

    protected static native String[] nListRoleMembers(long var0, String var2) throws JRDFoxException;

    protected static native boolean nIsMemberOf(long var0, String var2, String var3) throws JRDFoxException;

    protected static native boolean nGrantRole(long var0, String var2, String var3) throws JRDFoxException;

    protected static native boolean nRevokeRole(long var0, String var2, String var3) throws JRDFoxException;

    protected static native Map<String, Byte> nListPrivileges(long var0, String var2) throws JRDFoxException;

    protected static native boolean nGrantPrivileges(long var0, String var2, String var3, byte var4) throws JRDFoxException;

    protected static native boolean nRevokePrivileges(long var0, String var2, String var3, byte var4) throws JRDFoxException;

    protected final void markUsedEnsureValid() throws JRDFoxException {
        if (this.m_inUse.compareAndExchangeAcquire(false, true)) {
            throw new JRDFoxException("An operation (most likely initiated from another thread) is currently active on this server connection.");
        }
        if (this.m_serverConnectionPtr == 0L) {
            this.m_inUse.setRelease(false);
            throw new JRDFoxException("This server connection has been closed.");
        }
    }

    protected final void markUnused() {
        this.m_inUse.setRelease(false);
    }

    protected final ServerInfo getServerInfo() throws JRDFoxException {
        ServerInfo serverInfo = this.m_serverInfo;
        if (serverInfo == null) {
            this.markUsedEnsureValid();
            try {
                serverInfo = this.m_serverInfo;
                if (serverInfo == null) {
                    this.m_serverInfo = serverInfo = new ServerInfo(LocalServerConnection.nDescribeServer(this.m_serverConnectionPtr));
                }
            }
            finally {
                this.markUnused();
            }
        }
        return serverInfo;
    }

    protected LocalServerConnection(long l) throws JRDFoxException {
        this.m_serverConnectionPtr = l;
        this.m_serverInfo = null;
        this.m_inUse = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.m_inUse.compareAndExchangeAcquire(false, true)) {
            throw new IllegalStateException("The server  connection could not be closed because an operation on this connection (most likely initiated from another thread) is already in progress. Using server connections on multiple threads simultaneously is not supported (other than as mentioned in the documentation), so this is a bug in the code using RDFox.");
        }
        LocalServerConnection localServerConnection = this;
        synchronized (localServerConnection) {
            if (this.m_serverConnectionPtr != 0L) {
                LocalServerConnection.nClose(this.m_serverConnectionPtr);
                this.m_serverConnectionPtr = 0L;
            }
        }
        this.m_inUse.setRelease(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() throws JRDFoxException {
        LocalServerConnection localServerConnection = this;
        synchronized (localServerConnection) {
            if (this.m_serverConnectionPtr == 0L) {
                throw new JRDFoxException("This server connection has been closed.");
            }
            LocalServerConnection.nInterrupt(this.m_serverConnectionPtr);
        }
    }

    @Override
    public String getAgentName() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            String string = LocalServerConnection.nGetAgentName(this.m_serverConnectionPtr);
            return string;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerConnection duplicate() throws JRDFoxException {
        long l;
        LocalServerConnection localServerConnection = this;
        synchronized (localServerConnection) {
            if (this.m_serverConnectionPtr == 0L) {
                throw new JRDFoxException("This server connection has been closed.");
            }
            l = LocalServerConnection.nDuplicate(this.m_serverConnectionPtr);
        }
        try {
            return new LocalServerConnection(l);
        }
        catch (Throwable throwable) {
            LocalServerConnection.nClose(l);
            if (throwable instanceof JRDFoxException) {
                throw (JRDFoxException)throwable;
            }
            throw new JRDFoxException("Error while duplicating the connection.", throwable);
        }
    }

    @Override
    public Map<String, String> getParameters() throws JRDFoxException {
        return this.getServerInfo().m_parameters;
    }

    @Override
    public String getRDFoxVersion() throws JRDFoxException {
        return this.getServerInfo().m_rdfoxVersion;
    }

    @Override
    public String getRDFoxGitSHA() throws JRDFoxException {
        return this.getServerInfo().m_rdfoxGitSHA;
    }

    @Override
    public long[] getMemoryUse() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            long[] lArray = LocalServerConnection.nGetMemoryUse(this.m_serverConnectionPtr);
            return lArray;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void setMaxMemoryUse(long l) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nSetMaxMemoryUse(this.m_serverConnectionPtr, l);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public int getNumberOfThreads() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            int n = LocalServerConnection.nGetNumberOfThreads(this.m_serverConnectionPtr);
            return n;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void setNumberOfThreads(int n) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nSetNumberOfThreads(this.m_serverConnectionPtr, n);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public int getServerVersion() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            int n = LocalServerConnection.nGetServerVersion(this.m_serverConnectionPtr);
            return n;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkIntegrity(int n, OutputStream outputStream) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = LocalServerConnection.nCheckIntegrity(this.m_serverConnectionPtr, n, outputStream);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public ComponentInfo getComponentInfo(boolean bl) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            ComponentInfo componentInfo = LocalServerConnection.nGetComponentInfo(this.m_serverConnectionPtr, bl);
            return componentInfo;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public Map<String, Optional<DataStoreInfo>> listDataStores() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            Map<String, Optional<DataStoreInfo>> map = LocalServerConnection.nListDataStores(this.m_serverConnectionPtr);
            return map;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean containsDataStore(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = LocalServerConnection.nContainsDataStore(this.m_serverConnectionPtr, string);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public DataStoreInfo describeDataStore(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            DataStoreInfo dataStoreInfo = LocalServerConnection.nDescribeDataStore(this.m_serverConnectionPtr, string);
            return dataStoreInfo;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void createDataStore(String string, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nCreateDataStore(this.m_serverConnectionPtr, string, LocalServer.mapToStringArray(map));
        }
        finally {
            this.markUnused();
        }
    }

    public void loadDataStoreFromBinaryFormat(String string, InputStream inputStream) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nLoadDataStoreFromBinaryFormatStream(this.m_serverConnectionPtr, string, inputStream, null, null, null);
        }
        finally {
            this.markUnused();
        }
    }

    public void loadDataStoreFromBinaryFormat(String string, File file) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nLoadDataStoreFromBinaryFormatFile(this.m_serverConnectionPtr, string, file.getAbsolutePath(), null, null, null);
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataStoreFromBinaryFormat(String string, InputStream inputStream, String string2, String string3, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nLoadDataStoreFromBinaryFormatStream(this.m_serverConnectionPtr, string, inputStream, string2, string3, map == null ? null : LocalServer.mapToStringArray(map));
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataStoreFromBinaryFormat(String string, File file, String string2, String string3, Map<String, String> map) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nLoadDataStoreFromBinaryFormatFile(this.m_serverConnectionPtr, string, file.getAbsolutePath(), string2, string3, map == null ? null : LocalServer.mapToStringArray(map));
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDataStoreToBinaryFormat(String string, OutputStream outputStream, String string2, String string3, BinaryDataStoreFormat binaryDataStoreFormat) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nSaveDataStoreToBinaryFormatStream(this.m_serverConnectionPtr, string, outputStream, string2, string3, binaryDataStoreFormat.ordinal(), null);
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDataStoreToBinaryFormat(String string, OutputStream outputStream, String string2, String string3, BinaryDataStoreFormat binaryDataStoreFormat, DataStoreOperationStartMonitor dataStoreOperationStartMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nSaveDataStoreToBinaryFormatStream(this.m_serverConnectionPtr, string, outputStream, string2, string3, binaryDataStoreFormat.ordinal(), dataStoreOperationStartMonitor);
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDataStoreToBinaryFormat(String string, File file, String string2, String string3, BinaryDataStoreFormat binaryDataStoreFormat) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nSaveDataStoreToBinaryFormatFile(this.m_serverConnectionPtr, string, file.getAbsolutePath(), string2, string3, binaryDataStoreFormat.ordinal(), null);
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDataStoreToBinaryFormat(String string, File file, String string2, String string3, BinaryDataStoreFormat binaryDataStoreFormat, DataStoreOperationStartMonitor dataStoreOperationStartMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nSaveDataStoreToBinaryFormatFile(this.m_serverConnectionPtr, string, file.getAbsolutePath(), string2, string3, binaryDataStoreFormat.ordinal(), dataStoreOperationStartMonitor);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void deleteDataStore(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nDeleteDataStore(this.m_serverConnectionPtr, string, null);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void deleteDataStore(String string, DataStoreOperationStartMonitor dataStoreOperationStartMonitor) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nDeleteDataStore(this.m_serverConnectionPtr, string, dataStoreOperationStartMonitor);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean isDataStoreOnline(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = LocalServerConnection.nIsDataStoreOnline(this.m_serverConnectionPtr, string);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean bringDataStoreOnline(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = LocalServerConnection.nBringDataStoreOnline(this.m_serverConnectionPtr, string);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public OfflineRequestResult bringDataStoreOffline(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            OfflineRequestResult offlineRequestResult = LocalServerConnection.nBringDataStoreOffline(this.m_serverConnectionPtr, string);
            return offlineRequestResult;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStoreConnection newDataStoreConnection(String string) throws JRDFoxException {
        long l;
        this.markUsedEnsureValid();
        try {
            l = LocalServerConnection.nNewDataStoreConnection(this.m_serverConnectionPtr, string);
        }
        finally {
            this.markUnused();
        }
        try {
            return new LocalDataStoreConnection(string, l);
        }
        catch (Throwable throwable) {
            LocalDataStoreConnection.nClose(l);
            if (throwable instanceof JRDFoxException) {
                throw (JRDFoxException)throwable;
            }
            throw new JRDFoxException("Error while creating a data store connection.", throwable);
        }
    }

    @Override
    public List<String> listRoles() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            List<String> list = Arrays.asList(LocalServerConnection.nListRoles(this.m_serverConnectionPtr));
            return list;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void createRole(String string, String string2) throws JRDFoxException {
        this.createRole(string, PasswordSpecificationType.PASSWORD, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRole(String string, PasswordSpecificationType passwordSpecificationType, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nCreateRole(this.m_serverConnectionPtr, string, passwordSpecificationType.ordinal(), string2);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void deleteRole(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nDeleteRole(this.m_serverConnectionPtr, string);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void changeRolePassword(String string, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalServerConnection.nChangeRolePassword(this.m_serverConnectionPtr, string, string2);
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public String getRolePasswordHash(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            String string2 = LocalServerConnection.nGetRolePasswordHash(this.m_serverConnectionPtr, string);
            return string2;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public List<String> listRoleMemberships(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            List<String> list = Arrays.asList(LocalServerConnection.nListRoleMemberships(this.m_serverConnectionPtr, string));
            return list;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public List<String> listRoleMembers(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            List<String> list = Arrays.asList(LocalServerConnection.nListRoleMembers(this.m_serverConnectionPtr, string));
            return list;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMemberOf(String string, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = LocalServerConnection.nIsMemberOf(this.m_serverConnectionPtr, string, string2);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantRole(String string, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = LocalServerConnection.nGrantRole(this.m_serverConnectionPtr, string, string2);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokeRole(String string, String string2) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = LocalServerConnection.nRevokeRole(this.m_serverConnectionPtr, string, string2);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public Map<String, Byte> listPrivileges(String string) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            Map<String, Byte> map = LocalServerConnection.nListPrivileges(this.m_serverConnectionPtr, string);
            return map;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean grantPrivileges(String string, String string2, byte by) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = LocalServerConnection.nGrantPrivileges(this.m_serverConnectionPtr, string, string2, by);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokePrivileges(String string, String string2, byte by) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            boolean bl = LocalServerConnection.nRevokePrivileges(this.m_serverConnectionPtr, string, string2, by);
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    class ServerInfo {
        public final Map<String, String> m_parameters;
        public final String m_rdfoxVersion;
        public final String m_rdfoxGitSHA;

        public ServerInfo(String[] stringArray) {
            this.m_parameters = Collections.unmodifiableMap(LocalServer.stringArrayToMap(stringArray, 2));
            this.m_rdfoxVersion = stringArray[0];
            this.m_rdfoxGitSHA = stringArray[1];
        }
    }
}

