/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.local;

import java.util.function.Consumer;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.client.ResourceValue;
import tech.oxfordsemantic.jrdfox.logic.Datatype;
import tech.oxfordsemantic.jrdfox.logic.expression.BlankNode;
import tech.oxfordsemantic.jrdfox.logic.expression.IRI;
import tech.oxfordsemantic.jrdfox.logic.expression.Literal;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;

public class LocalResourceValue
implements ResourceValue {
    public String m_lexicalForm;
    public Datatype m_datatype;

    public LocalResourceValue() {
        this.m_lexicalForm = null;
        this.m_datatype = null;
    }

    public LocalResourceValue(String string, Datatype datatype) {
        this.m_lexicalForm = string;
        this.m_datatype = datatype;
    }

    @Override
    public boolean isValid() {
        return this.m_datatype != null;
    }

    @Override
    public String getLexicalForm() {
        return this.m_lexicalForm;
    }

    @Override
    public Datatype getDatatype() {
        return this.m_datatype;
    }

    @Override
    public Resource toResource() {
        if (this.m_datatype == null) {
            return null;
        }
        switch (this.m_datatype) {
            case IRI_REFERENCE: {
                return IRI.create(this.m_lexicalForm);
            }
            case BLANK_NODE: {
                return BlankNode.create(this.m_lexicalForm);
            }
        }
        return Literal.create(this.m_lexicalForm, this.m_datatype);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ResourceValue.toString(Prefixes.s_defaultPrefixes, stringBuilder::append, this.m_lexicalForm, this.m_datatype);
        return stringBuilder.toString();
    }

    @Override
    public String toString(Prefixes prefixes) {
        StringBuilder stringBuilder = new StringBuilder();
        ResourceValue.toString(prefixes, stringBuilder::append, this.m_lexicalForm, this.m_datatype);
        return stringBuilder.toString();
    }

    public void toString(Prefixes prefixes, Consumer<String> consumer) {
        ResourceValue.toString(prefixes, consumer, this.m_lexicalForm, this.m_datatype);
    }
}

