/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.local;

import tech.oxfordsemantic.jrdfox.client.Cursor;
import tech.oxfordsemantic.jrdfox.client.CursorType;
import tech.oxfordsemantic.jrdfox.client.DataStoreConnection;
import tech.oxfordsemantic.jrdfox.client.ResourceValue;
import tech.oxfordsemantic.jrdfox.client.TransactionState;
import tech.oxfordsemantic.jrdfox.client.TransactionType;
import tech.oxfordsemantic.jrdfox.exceptions.InvalidCursorStateException;
import tech.oxfordsemantic.jrdfox.exceptions.JRDFoxException;
import tech.oxfordsemantic.jrdfox.local.LocalDataStoreConnection;
import tech.oxfordsemantic.jrdfox.logic.expression.Resource;

public class LocalCursor
implements Cursor {
    protected final LocalDataStoreConnection m_dataStoreConnection;
    protected long m_cursorPtr;
    protected long m_resourceValueCachePtr;
    protected final CursorType m_cursorType;
    protected final int m_arity;
    protected final String[] m_answerVariableNames;
    protected final long m_helperBufferPtr;
    protected final long m_multiplicitiesEndPtr;
    protected final long[] m_multiplicities;
    protected final int m_fetchWindowSize;
    protected final long[] m_resourceIDs;
    protected final ResourceValue[] m_resourceValues;
    protected final long[] m_currentOffsetAndDictionaryVersion;
    protected int m_numberOfAnswersInWindow;
    protected int m_currentAnswerIndex;
    protected int m_currentResourceIDsIndex;

    protected static native void nClose(long var0, long var2);

    protected static native int nOpen(long var0, long var2, long var4, long[] var6, long[] var7, long[] var8, long var9, long var11) throws JRDFoxException;

    protected static native boolean nCanAdvance(long var0) throws JRDFoxException;

    protected static native int nAdvance(long var0, long var2, long[] var4, long[] var5, long[] var6, long var7, long var9) throws JRDFoxException;

    protected static native void nStop(long var0) throws JRDFoxException;

    protected final void markUsedEnsureValid() throws JRDFoxException {
        this.m_dataStoreConnection.markUsedEnsureValid();
        if (this.m_cursorPtr == 0L) {
            this.m_dataStoreConnection.markUnused();
            throw new JRDFoxException("This cursor has been closed.");
        }
    }

    protected final void markUnused() {
        this.m_dataStoreConnection.markUnused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocalCursor(LocalDataStoreConnection localDataStoreConnection, long l, long l2, CursorType cursorType, int n, String[] stringArray, long l3, long l4, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The fetch window size must be greater than 0.");
        }
        this.m_dataStoreConnection = localDataStoreConnection;
        this.m_cursorPtr = l;
        this.m_resourceValueCachePtr = l2;
        this.m_cursorType = cursorType;
        this.m_arity = n;
        this.m_answerVariableNames = stringArray;
        this.m_helperBufferPtr = l3;
        this.m_multiplicitiesEndPtr = l4;
        this.m_fetchWindowSize = n2;
        this.m_multiplicities = new long[this.m_fetchWindowSize];
        this.m_resourceIDs = new long[this.m_fetchWindowSize * this.m_arity];
        this.m_resourceValues = new ResourceValue[this.m_fetchWindowSize * this.m_arity];
        this.m_currentOffsetAndDictionaryVersion = new long[2];
        this.m_currentResourceIDsIndex = 0;
        this.m_currentAnswerIndex = 0;
        this.m_numberOfAnswersInWindow = 0;
        LocalDataStoreConnection localDataStoreConnection2 = this.m_dataStoreConnection;
        synchronized (localDataStoreConnection2) {
            ++this.m_dataStoreConnection.m_numberOfCursors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.m_dataStoreConnection.m_inUse.compareAndExchangeAcquire(false, true)) {
            throw new IllegalStateException("The cursor could not be closed because an operation on the associated connection (most likely initiated from another thread) is already in progress. Using data store connections and cursors created from them on multiple threads simultaneously is not supported (other than as mentioned in the documentation), so this is a bug in the code using RDFox.");
        }
        LocalDataStoreConnection localDataStoreConnection = this.m_dataStoreConnection;
        synchronized (localDataStoreConnection) {
            if (this.m_cursorPtr != 0L) {
                LocalCursor.nClose(this.m_cursorPtr, this.m_helperBufferPtr);
                this.m_cursorPtr = 0L;
                --this.m_dataStoreConnection.m_numberOfCursors;
            }
        }
        this.m_dataStoreConnection.m_inUse.setRelease(false);
    }

    @Override
    public DataStoreConnection getDataStoreConnection() {
        return this.m_dataStoreConnection;
    }

    @Override
    public CursorType getCursorType() {
        return this.m_cursorType;
    }

    @Override
    public int getArity() {
        return this.m_arity;
    }

    @Override
    public String getAnswerVariableName(int n) throws JRDFoxException {
        return this.m_answerVariableNames[n];
    }

    @Override
    public ResourceValue getResourceValue(int n) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            if (this.m_multiplicities[this.m_currentAnswerIndex] == 0L) {
                throw new InvalidCursorStateException("The cursor is not positioned on a valid answer.");
            }
            ResourceValue resourceValue = this.m_resourceValues[this.m_currentResourceIDsIndex + n];
            return resourceValue;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public Resource getResource(int n) throws JRDFoxException {
        return this.getResourceValue(n).toResource();
    }

    @Override
    public long open() throws JRDFoxException {
        return this.open(0L);
    }

    /*
     * Loose catch block
     */
    @Override
    public long open(long l) throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            int n = LocalDataStoreConnection.nGetTransactionState(this.m_dataStoreConnection.m_dataStoreConnectionPtr);
            if (n == TransactionState.NONE.ordinal()) {
                LocalDataStoreConnection.nBeginTransaction(this.m_dataStoreConnection.m_dataStoreConnectionPtr, TransactionType.READ_ONLY.ordinal());
            }
            try {
                this.m_currentResourceIDsIndex = 0;
                this.m_currentAnswerIndex = 0;
                this.m_numberOfAnswersInWindow = LocalCursor.nOpen(this.m_cursorPtr, this.m_resourceValueCachePtr, l, this.m_currentOffsetAndDictionaryVersion, this.m_multiplicities, this.m_resourceIDs, this.m_helperBufferPtr, this.m_multiplicitiesEndPtr);
                if (this.m_numberOfAnswersInWindow == 0) {
                    this.m_multiplicities[this.m_currentAnswerIndex] = 0L;
                } else if (n >= TransactionState.READ_ONLY.ordinal()) {
                    this.m_dataStoreConnection.m_resourceValueCache.getResourceValuesUseCache(this.m_resourceValueCachePtr, this.m_resourceIDs, this.m_numberOfAnswersInWindow * this.m_arity, this.m_resourceValues, this.m_currentOffsetAndDictionaryVersion[1]);
                } else {
                    this.m_dataStoreConnection.m_resourceValueCache.getResourceValuesNoCache(this.m_resourceValueCachePtr, this.m_resourceIDs, this.m_numberOfAnswersInWindow * this.m_arity, this.m_resourceValues);
                }
                long l2 = this.m_multiplicities[this.m_currentAnswerIndex];
                return l2;
            }
            catch (JRDFoxException jRDFoxException) {
                this.m_numberOfAnswersInWindow = 0;
                this.m_multiplicities[this.m_currentAnswerIndex] = 0L;
                this.m_currentOffsetAndDictionaryVersion[0] = 0L;
                LocalCursor.nStop(this.m_cursorPtr);
                throw jRDFoxException;
            }
            finally {
                if (n == TransactionState.NONE.ordinal()) {
                    LocalDataStoreConnection.nRollbackTransaction(this.m_dataStoreConnection.m_dataStoreConnectionPtr);
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public boolean canAdvance() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            if (this.m_currentAnswerIndex + 1 < this.m_numberOfAnswersInWindow) {
                boolean bl = true;
                return bl;
            }
            if (this.m_numberOfAnswersInWindow == this.m_fetchWindowSize) {
                boolean bl = LocalCursor.nCanAdvance(this.m_cursorPtr);
                return bl;
            }
            boolean bl = this.m_currentAnswerIndex < this.m_numberOfAnswersInWindow;
            return bl;
        }
        finally {
            this.markUnused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long advance() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            this.m_currentOffsetAndDictionaryVersion[0] = this.m_currentOffsetAndDictionaryVersion[0] + this.m_multiplicities[this.m_currentAnswerIndex];
            int n = this.m_currentAnswerIndex + 1;
            if (n < this.m_numberOfAnswersInWindow) {
                this.m_currentAnswerIndex = n;
                this.m_currentResourceIDsIndex += this.m_arity;
            } else if (this.m_numberOfAnswersInWindow == this.m_fetchWindowSize) {
                int n2 = LocalDataStoreConnection.nGetTransactionState(this.m_dataStoreConnection.m_dataStoreConnectionPtr);
                if (n2 == TransactionState.NONE.ordinal()) {
                    LocalDataStoreConnection.nBeginTransaction(this.m_dataStoreConnection.m_dataStoreConnectionPtr, TransactionType.READ_ONLY.ordinal());
                }
                try {
                    this.m_currentResourceIDsIndex = 0;
                    this.m_currentAnswerIndex = 0;
                    this.m_numberOfAnswersInWindow = LocalCursor.nAdvance(this.m_cursorPtr, this.m_resourceValueCachePtr, this.m_currentOffsetAndDictionaryVersion, this.m_multiplicities, this.m_resourceIDs, this.m_helperBufferPtr, this.m_multiplicitiesEndPtr);
                    if (this.m_numberOfAnswersInWindow == 0) {
                        this.m_multiplicities[this.m_currentAnswerIndex] = 0L;
                    }
                    if (n2 >= TransactionState.READ_ONLY.ordinal()) {
                        this.m_dataStoreConnection.m_resourceValueCache.getResourceValuesUseCache(this.m_resourceValueCachePtr, this.m_resourceIDs, this.m_numberOfAnswersInWindow * this.m_arity, this.m_resourceValues, this.m_currentOffsetAndDictionaryVersion[1]);
                    }
                    this.m_dataStoreConnection.m_resourceValueCache.getResourceValuesNoCache(this.m_resourceValueCachePtr, this.m_resourceIDs, this.m_numberOfAnswersInWindow * this.m_arity, this.m_resourceValues);
                }
                catch (JRDFoxException jRDFoxException) {
                    this.m_numberOfAnswersInWindow = 0;
                    this.m_multiplicities[this.m_currentAnswerIndex] = 0L;
                    this.m_currentOffsetAndDictionaryVersion[0] = 0L;
                    LocalCursor.nStop(this.m_cursorPtr);
                    throw jRDFoxException;
                }
                finally {
                    if (n2 == TransactionState.NONE.ordinal()) {
                        LocalDataStoreConnection.nRollbackTransaction(this.m_dataStoreConnection.m_dataStoreConnectionPtr);
                    }
                }
            } else if (this.m_currentAnswerIndex < this.m_numberOfAnswersInWindow) {
                this.m_currentResourceIDsIndex = 0;
                this.m_currentAnswerIndex = 0;
                this.m_numberOfAnswersInWindow = 0;
                this.m_multiplicities[this.m_currentAnswerIndex] = 0L;
            } else {
                throw new InvalidCursorStateException("This cursor is currently positioned after the last answer.");
            }
            long l = this.m_multiplicities[this.m_currentAnswerIndex];
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public long getCurrentOffset() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            long l = this.m_currentOffsetAndDictionaryVersion[0];
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public long getCurrentMultiplicity() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            long l = this.m_multiplicities[this.m_currentAnswerIndex];
            return l;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public int getNumberOfAnswersInWindow() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            int n = this.m_numberOfAnswersInWindow;
            return n;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public int getIndexOfCurrentAnswerInWindow() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            int n = this.m_currentAnswerIndex;
            return n;
        }
        finally {
            this.markUnused();
        }
    }

    @Override
    public void stop() throws JRDFoxException {
        this.markUsedEnsureValid();
        try {
            LocalCursor.nStop(this.m_cursorPtr);
            this.m_currentResourceIDsIndex = 0;
            this.m_currentAnswerIndex = 0;
            this.m_numberOfAnswersInWindow = 0;
            this.m_multiplicities[this.m_currentAnswerIndex] = 0L;
            this.m_currentOffsetAndDictionaryVersion[0] = 0L;
        }
        finally {
            this.markUnused();
        }
    }
}

