/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.formats.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import tech.oxfordsemantic.jrdfox.formats.internal.InputSource;
import tech.oxfordsemantic.jrdfox.formats.internal.TurtleSyntax;
import tech.oxfordsemantic.jrdfox.formats.internal.UTF16InputSource;
import tech.oxfordsemantic.jrdfox.formats.internal.UTF8InputSource;

public final class CommonTokenizer {
    protected static final int[] HEXtoDEC = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    protected final InputSource m_inputSource;
    protected boolean m_isAtEOF;
    protected int m_currentCodePoint;
    protected int m_currentCodePointLine;
    protected int m_currentCodePointColumn;
    protected int m_savedInputSourcePosition;
    protected boolean m_savedIsAtEOF;
    protected int m_savedCurrentCodePoint;
    protected int m_savedCurrentCodePointLine;
    protected int m_savedCurrentCodePointColumn;
    protected TokenType m_tokenType;
    protected final StringBuilder m_tokenBuffer;
    protected int m_tokenStartLine;
    protected int m_tokenStartColumn;

    protected void savePosition() {
        this.m_savedInputSourcePosition = this.m_inputSource.takeSnapshot();
        this.m_savedIsAtEOF = this.m_isAtEOF;
        this.m_savedCurrentCodePoint = this.m_currentCodePoint;
        this.m_savedCurrentCodePointLine = this.m_currentCodePointLine;
        this.m_savedCurrentCodePointColumn = this.m_currentCodePointColumn;
    }

    protected void restorePosition() {
        this.m_inputSource.restoreSnapshot(this.m_savedInputSourcePosition);
        this.m_isAtEOF = this.m_savedIsAtEOF;
        this.m_currentCodePoint = this.m_savedCurrentCodePoint;
        this.m_currentCodePointLine = this.m_savedCurrentCodePointLine;
        this.m_currentCodePointColumn = this.m_savedCurrentCodePointColumn;
    }

    protected void appendToToken(int n) {
        if (Character.isBmpCodePoint(n)) {
            this.m_tokenBuffer.append((char)n);
        } else {
            int n2 = n - 65536;
            this.m_tokenBuffer.append((char)((n2 >> 10) + 55296));
            this.m_tokenBuffer.append((char)((n2 & 0x3FF) + 56320));
        }
    }

    protected void loadNextCodePoint() throws IOException {
        this.m_currentCodePoint = this.m_inputSource.nextCodePoint();
        if (this.m_currentCodePoint == -1) {
            this.m_isAtEOF = true;
        }
    }

    protected void nextCodePoint() throws IOException {
        assert (!this.m_isAtEOF);
        if (this.m_currentCodePoint == 10) {
            ++this.m_currentCodePointLine;
            this.m_currentCodePointColumn = 1;
        } else {
            ++this.m_currentCodePointColumn;
        }
        this.loadNextCodePoint();
    }

    protected int readHexEncodedCodePoint(int n) throws IOException {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.m_isAtEOF) {
                this.m_tokenType = TokenType.ERROR_TOKEN;
                return 0;
            }
            int n3 = this.m_currentCodePoint;
            this.nextCodePoint();
            if (n3 >= 256) {
                this.m_tokenType = TokenType.ERROR_TOKEN;
                return 0;
            }
            int n4 = HEXtoDEC[n3];
            if (n4 == -1) {
                this.m_tokenType = TokenType.ERROR_TOKEN;
                return 0;
            }
            n2 = n2 * 16 + n4;
        }
        return n2;
    }

    protected boolean parseQuotedIRI() throws IOException {
        while (!this.m_isAtEOF) {
            int n = this.m_currentCodePoint;
            this.nextCodePoint();
            if (n == 62) {
                this.m_tokenType = TokenType.QUOTED_IRI;
                return true;
            }
            if (n == 92) {
                if (this.m_isAtEOF) {
                    this.m_tokenType = TokenType.ERROR_TOKEN;
                    return true;
                }
                int n2 = this.m_currentCodePoint;
                this.nextCodePoint();
                switch (n2) {
                    case 117: {
                        this.appendToToken(this.readHexEncodedCodePoint(4));
                        break;
                    }
                    case 85: {
                        this.appendToToken(this.readHexEncodedCodePoint(8));
                        break;
                    }
                    default: {
                        this.m_tokenType = TokenType.ERROR_TOKEN;
                        return true;
                    }
                }
                continue;
            }
            if (!TurtleSyntax.is_IRIREF(n)) {
                return false;
            }
            this.appendToToken(n);
        }
        return false;
    }

    protected boolean parseQuotedString() throws IOException {
        boolean bl;
        int n = this.m_currentCodePoint;
        this.nextCodePoint();
        if (this.m_isAtEOF) {
            return false;
        }
        if (this.m_currentCodePoint == n) {
            this.nextCodePoint();
            if (this.m_isAtEOF || this.m_currentCodePoint != n) {
                return true;
            }
            this.nextCodePoint();
            bl = true;
        } else {
            bl = false;
        }
        block17: while (!this.m_isAtEOF) {
            int n2 = this.m_currentCodePoint;
            this.nextCodePoint();
            switch (n2) {
                case 34: 
                case 39: {
                    if (n2 == n) {
                        if (bl) {
                            if (this.m_isAtEOF) {
                                return false;
                            }
                            if (this.m_currentCodePoint == n) {
                                this.nextCodePoint();
                                if (this.m_isAtEOF) {
                                    return false;
                                }
                                if (this.m_currentCodePoint == n) {
                                    this.nextCodePoint();
                                    return true;
                                }
                                this.appendToToken(n2);
                                this.appendToToken(n2);
                                continue block17;
                            }
                            this.appendToToken(n2);
                            continue block17;
                        }
                        return true;
                    }
                    this.appendToToken(n2);
                    continue block17;
                }
                case 92: {
                    if (this.m_isAtEOF) {
                        return false;
                    }
                    n2 = this.m_currentCodePoint;
                    this.nextCodePoint();
                    switch (n2) {
                        case 116: {
                            this.appendToToken(9);
                            continue block17;
                        }
                        case 98: {
                            this.appendToToken(8);
                            continue block17;
                        }
                        case 110: {
                            this.appendToToken(10);
                            continue block17;
                        }
                        case 114: {
                            this.appendToToken(13);
                            continue block17;
                        }
                        case 102: {
                            this.appendToToken(12);
                            continue block17;
                        }
                        case 34: {
                            this.appendToToken(34);
                            continue block17;
                        }
                        case 39: {
                            this.appendToToken(39);
                            continue block17;
                        }
                        case 92: {
                            this.appendToToken(92);
                            continue block17;
                        }
                        case 117: {
                            this.appendToToken(this.readHexEncodedCodePoint(4));
                            continue block17;
                        }
                        case 85: {
                            this.appendToToken(this.readHexEncodedCodePoint(8));
                            continue block17;
                        }
                    }
                    return false;
                }
                case 10: 
                case 13: {
                    if (bl) break;
                    return false;
                }
            }
            this.appendToToken(n2);
        }
        return false;
    }

    protected void readTokenWithDots(byte[] byArray) throws IOException {
        while (!this.m_isAtEOF) {
            if (TurtleSyntax.isInCodePointClass(byArray, this.m_currentCodePoint)) {
                this.appendToToken(this.m_currentCodePoint);
                this.nextCodePoint();
                continue;
            }
            if (this.m_currentCodePoint == 46) {
                this.savePosition();
                int n = 0;
                while (!this.m_isAtEOF && this.m_currentCodePoint == 46) {
                    this.nextCodePoint();
                    ++n;
                }
                if (!this.m_isAtEOF && TurtleSyntax.isInCodePointClass(byArray, this.m_currentCodePoint)) {
                    for (int i = 0; i < n; ++i) {
                        this.appendToToken(46);
                    }
                    this.m_inputSource.stopBuffering();
                    continue;
                }
                this.restorePosition();
                return;
            }
            return;
        }
    }

    protected boolean readCodePoint(int n) throws IOException {
        if (!this.m_isAtEOF && this.m_currentCodePoint == n) {
            this.appendToToken(n);
            this.nextCodePoint();
            return true;
        }
        return false;
    }

    protected boolean readCodePoint(byte[] byArray) throws IOException {
        if (!this.m_isAtEOF && TurtleSyntax.isInCodePointClass(byArray, this.m_currentCodePoint)) {
            this.appendToToken(this.m_currentCodePoint);
            this.nextCodePoint();
            return true;
        }
        return false;
    }

    protected boolean read_PERCENT() throws IOException {
        if (!this.m_isAtEOF && this.m_currentCodePoint == 37) {
            this.savePosition();
            this.nextCodePoint();
            if (!this.m_isAtEOF && HEXtoDEC[this.m_currentCodePoint] != -1) {
                int n = this.m_currentCodePoint;
                this.nextCodePoint();
                if (!this.m_isAtEOF && HEXtoDEC[this.m_currentCodePoint] != -1) {
                    int n2 = this.m_currentCodePoint;
                    this.nextCodePoint();
                    this.appendToToken(37);
                    this.appendToToken(n);
                    this.appendToToken(n2);
                    this.m_inputSource.stopBuffering();
                    return true;
                }
            }
            this.restorePosition();
        }
        return false;
    }

    protected boolean read_PN_LOCAL_ESC() throws IOException {
        if (this.m_currentCodePoint == 92) {
            this.savePosition();
            this.nextCodePoint();
            if (TurtleSyntax.is_PN_LOCAL_ESC(this.m_currentCodePoint)) {
                this.appendToToken(92);
                this.appendToToken(this.m_currentCodePoint);
                this.nextCodePoint();
                this.m_inputSource.stopBuffering();
                return true;
            }
            this.restorePosition();
        }
        return false;
    }

    public CommonTokenizer(InputSource inputSource) throws IOException {
        this.m_inputSource = inputSource;
        this.m_isAtEOF = false;
        this.m_currentCodePoint = 0;
        this.m_currentCodePointLine = 1;
        this.m_currentCodePointColumn = 1;
        this.m_savedInputSourcePosition = -1;
        this.m_tokenType = TokenType.NO_TOKEN;
        this.m_tokenBuffer = new StringBuilder();
        this.m_tokenStartLine = 0;
        this.m_tokenStartColumn = 0;
        this.loadNextCodePoint();
    }

    public CommonTokenizer(InputStream inputStream) throws IOException {
        this(new UTF8InputSource(inputStream));
    }

    public CommonTokenizer(Reader reader) throws IOException {
        this(new UTF16InputSource(reader));
    }

    public boolean isGood() {
        return this.m_tokenType != TokenType.EOF_TOKEN && this.m_tokenType != TokenType.ERROR_TOKEN;
    }

    public boolean isNoToken() {
        return this.m_tokenType == TokenType.NO_TOKEN;
    }

    public boolean isErrorToken() {
        return this.m_tokenType == TokenType.ERROR_TOKEN;
    }

    public boolean isEOF() {
        return this.m_tokenType == TokenType.EOF_TOKEN;
    }

    public boolean isInteger() {
        return this.m_tokenType == TokenType.INTEGER;
    }

    public boolean isIntegerWithExponent() {
        return this.m_tokenType == TokenType.INTEGER_WITH_EXPONENT;
    }

    public boolean isDecimalWithExponent() {
        return this.m_tokenType == TokenType.DECIMAL_WITH_EXPONENT;
    }

    public boolean isDecimal() {
        return this.m_tokenType == TokenType.DECIMAL;
    }

    public boolean isSymbol() {
        return this.m_tokenType == TokenType.SYMBOL;
    }

    public boolean is_PNAME_NS() {
        return this.m_tokenType == TokenType.PNAME_NS;
    }

    public boolean is_PNAME_LN() {
        return this.m_tokenType == TokenType.PNAME_LN;
    }

    public boolean isLanguageTag() {
        return this.m_tokenType == TokenType.LANGUAGE_TAG;
    }

    public boolean isNonSymbol() {
        return this.m_tokenType == TokenType.NON_SYMBOL;
    }

    public boolean isVariable() {
        return this.m_tokenType == TokenType.VARIABLE;
    }

    public boolean isQuotedIRI() {
        return this.m_tokenType == TokenType.QUOTED_IRI;
    }

    public boolean isQuotedString() {
        return this.m_tokenType == TokenType.QUOTED_STRING;
    }

    public boolean isBlankNode() {
        return this.m_tokenType == TokenType.BLANK_NODE;
    }

    public TokenType getTokenType() {
        return this.m_tokenType;
    }

    public StringBuilder getTokenBuffer() {
        return this.m_tokenBuffer;
    }

    public String getToken() {
        return this.m_tokenBuffer.toString();
    }

    public String getToken(int n) {
        return this.m_tokenBuffer.substring(n);
    }

    public void appendToken(StringBuilder stringBuilder) {
        stringBuilder.append((CharSequence)this.m_tokenBuffer);
    }

    public void appendToken(StringBuilder stringBuilder, int n) {
        stringBuilder.append(this.m_tokenBuffer, n, this.m_tokenBuffer.length());
    }

    public boolean tokenEquals(TokenType tokenType, char c) {
        return this.m_tokenType == tokenType && this.m_tokenBuffer.length() == 1 && this.m_tokenBuffer.charAt(0) == c;
    }

    public boolean tokenEqualsNoType(char c) {
        return this.m_tokenBuffer.length() == 1 && this.m_tokenBuffer.charAt(0) == c;
    }

    public boolean nonSymbolTokenEqualsOneOf(char c, char c2, char c3, char c4, char c5) {
        char c6 = this.m_tokenBuffer.charAt(0);
        return this.m_tokenType == TokenType.NON_SYMBOL && this.m_tokenBuffer.length() == 1 && (c6 == c || c6 == c2 || c6 == c3 || c6 == c4 || c6 == c5);
    }

    public boolean tokenEquals(TokenType tokenType, String string) {
        return this.m_tokenType == tokenType && this.tokenEqualsNoType(string);
    }

    public boolean tokenEqualsNoType(String string) {
        int n = this.m_tokenBuffer.length();
        if (n != string.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.m_tokenBuffer.charAt(i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean lowerCaseTokenEquals(TokenType tokenType, String string) {
        return this.m_tokenType == tokenType && this.lowerCaseTokenEqualsNoType(string);
    }

    public boolean lowerCaseTokenEqualsNoType(String string) {
        int n = this.m_tokenBuffer.length();
        if (n != string.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.toLowerCase(this.m_tokenBuffer.charAt(i)) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean nonSymbolTokenEquals(char c) {
        return this.tokenEquals(TokenType.NON_SYMBOL, c);
    }

    public boolean nonSymbolTokenEquals(String string) {
        return this.tokenEquals(TokenType.NON_SYMBOL, string);
    }

    public boolean symbolTokenEquals(String string) {
        return this.tokenEquals(TokenType.SYMBOL, string);
    }

    public boolean symbolLowerCaseTokenEquals(String string) {
        return this.lowerCaseTokenEquals(TokenType.SYMBOL, string);
    }

    public int getCurrentCodePointLine() {
        return this.m_currentCodePointLine;
    }

    public int getCurrentCodePointColumn() {
        return this.m_currentCodePointColumn;
    }

    public int getTokenStartLine() {
        return this.m_tokenStartLine;
    }

    public int getTokenStartColumn() {
        return this.m_tokenStartColumn;
    }

    public void nextToken() throws IOException {
        this.m_tokenBuffer.setLength(0);
        boolean bl = false;
        while (true) {
            if (this.m_isAtEOF) {
                this.m_tokenType = TokenType.EOF_TOKEN;
                return;
            }
            if (bl) {
                if (this.m_currentCodePoint == 10) {
                    bl = false;
                }
            } else if (this.m_currentCodePoint == 35) {
                bl = true;
            } else if (!TurtleSyntax.isWhitespace(this.m_currentCodePoint)) break;
            this.nextCodePoint();
        }
        this.m_tokenStartLine = this.m_currentCodePointLine;
        this.m_tokenStartColumn = this.m_currentCodePointColumn;
        block0 : switch (this.m_currentCodePoint) {
            case 60: {
                this.nextCodePoint();
                if (this.m_isAtEOF) {
                    this.appendToToken(60);
                    this.m_tokenType = TokenType.NON_SYMBOL;
                    break;
                }
                this.savePosition();
                if (this.parseQuotedIRI()) {
                    this.m_inputSource.stopBuffering();
                    break;
                }
                this.m_tokenBuffer.setLength(0);
                this.appendToToken(60);
                this.restorePosition();
                if (this.m_currentCodePoint == 61) {
                    this.appendToToken(61);
                    this.nextCodePoint();
                }
                this.m_tokenType = TokenType.NON_SYMBOL;
                break;
            }
            case 34: 
            case 39: {
                if (this.parseQuotedString()) {
                    this.m_tokenType = TokenType.QUOTED_STRING;
                    break;
                }
                this.m_tokenType = TokenType.ERROR_TOKEN;
                break;
            }
            case 33: {
                this.appendToToken(33);
                this.nextCodePoint();
                this.readCodePoint(61);
                this.m_tokenType = TokenType.NON_SYMBOL;
                break;
            }
            case 62: {
                this.appendToToken(62);
                this.nextCodePoint();
                this.readCodePoint(61);
                this.m_tokenType = TokenType.NON_SYMBOL;
                break;
            }
            case 94: {
                this.appendToToken(94);
                this.nextCodePoint();
                this.readCodePoint(94);
                this.m_tokenType = TokenType.NON_SYMBOL;
                break;
            }
            case 124: {
                this.appendToToken(124);
                this.nextCodePoint();
                this.readCodePoint(124);
                this.m_tokenType = TokenType.NON_SYMBOL;
                break;
            }
            case 38: {
                this.appendToToken(38);
                this.nextCodePoint();
                if (this.readCodePoint(38)) {
                    this.m_tokenType = TokenType.NON_SYMBOL;
                    break;
                }
                this.m_tokenType = TokenType.ERROR_TOKEN;
                break;
            }
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.appendToToken(this.m_currentCodePoint);
                if (this.m_currentCodePoint == 46) {
                    this.nextCodePoint();
                    if (this.m_isAtEOF || !TurtleSyntax.is_NUMBER(this.m_currentCodePoint)) {
                        this.m_tokenType = TokenType.NON_SYMBOL;
                        return;
                    }
                    this.m_tokenType = TokenType.DECIMAL;
                    while (!this.m_isAtEOF && TurtleSyntax.is_NUMBER(this.m_currentCodePoint)) {
                        this.appendToToken(this.m_currentCodePoint);
                        this.nextCodePoint();
                    }
                } else {
                    this.nextCodePoint();
                    this.m_tokenType = TokenType.INTEGER;
                    while (!this.m_isAtEOF && TurtleSyntax.is_NUMBER(this.m_currentCodePoint)) {
                        this.appendToToken(this.m_currentCodePoint);
                        this.nextCodePoint();
                    }
                    if (!this.m_isAtEOF && this.m_currentCodePoint == 46) {
                        this.savePosition();
                        this.nextCodePoint();
                        if (this.m_isAtEOF || !TurtleSyntax.is_NUMBER(this.m_currentCodePoint)) {
                            this.restorePosition();
                            return;
                        }
                        this.m_inputSource.stopBuffering();
                        this.appendToToken(46);
                        while (!this.m_isAtEOF && TurtleSyntax.is_NUMBER(this.m_currentCodePoint)) {
                            this.appendToToken(this.m_currentCodePoint);
                            this.nextCodePoint();
                        }
                        this.m_tokenType = TokenType.DECIMAL;
                    }
                }
                if (this.m_isAtEOF || this.m_currentCodePoint != 101 && this.m_currentCodePoint != 69) break;
                this.savePosition();
                int n = this.m_currentCodePoint;
                this.nextCodePoint();
                int n2 = 0;
                if (this.m_currentCodePoint == 45 || this.m_currentCodePoint == 43) {
                    n2 = this.m_currentCodePoint;
                    this.nextCodePoint();
                }
                if (this.m_isAtEOF || !TurtleSyntax.is_NUMBER(this.m_currentCodePoint)) {
                    this.restorePosition();
                    return;
                }
                this.m_inputSource.stopBuffering();
                this.appendToToken(n);
                if (n2 != 0) {
                    this.appendToToken(n2);
                }
                while (!this.m_isAtEOF && TurtleSyntax.is_NUMBER(this.m_currentCodePoint)) {
                    this.appendToToken(this.m_currentCodePoint);
                    this.nextCodePoint();
                }
                if (this.m_tokenType == TokenType.INTEGER) {
                    this.m_tokenType = TokenType.INTEGER_WITH_EXPONENT;
                    break;
                }
                this.m_tokenType = TokenType.DECIMAL_WITH_EXPONENT;
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 59: 
            case 61: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                this.appendToToken(this.m_currentCodePoint);
                this.nextCodePoint();
                this.m_tokenType = TokenType.NON_SYMBOL;
                break;
            }
            case 64: {
                this.appendToToken(this.m_currentCodePoint);
                this.nextCodePoint();
                if (this.m_isAtEOF || !TurtleSyntax.is_ALPHA(this.m_currentCodePoint)) {
                    this.m_tokenType = TokenType.ERROR_TOKEN;
                    break;
                }
                while (!this.m_isAtEOF && TurtleSyntax.is_ALPHA(this.m_currentCodePoint)) {
                    this.appendToToken(this.m_currentCodePoint);
                    this.nextCodePoint();
                }
                while (!this.m_isAtEOF && this.m_currentCodePoint == 45) {
                    this.savePosition();
                    this.nextCodePoint();
                    if (!this.m_isAtEOF && TurtleSyntax.is_ALPHA_NUMBER(this.m_currentCodePoint)) {
                        this.appendToToken(45);
                        this.m_inputSource.stopBuffering();
                    } else {
                        this.restorePosition();
                        break;
                    }
                    while (!this.m_isAtEOF && TurtleSyntax.is_ALPHA_NUMBER(this.m_currentCodePoint)) {
                        this.appendToToken(this.m_currentCodePoint);
                        this.nextCodePoint();
                    }
                }
                this.m_tokenType = TokenType.LANGUAGE_TAG;
                break;
            }
            case 95: {
                this.appendToToken(95);
                this.nextCodePoint();
                if (this.readCodePoint(58) && this.readCodePoint(TurtleSyntax.PN_CHARS_U_NUM)) {
                    this.readTokenWithDots(TurtleSyntax.PN_CHARS);
                    this.m_tokenType = TokenType.BLANK_NODE;
                    break;
                }
                this.m_tokenType = TokenType.ERROR_TOKEN;
                break;
            }
            case 36: {
                this.appendToToken(this.m_currentCodePoint);
                this.nextCodePoint();
                if (this.readCodePoint(TurtleSyntax.PN_CHARS_U_NUM)) {
                    while (this.readCodePoint(TurtleSyntax.PN_CHARS_VAR2)) {
                    }
                    this.m_tokenType = TokenType.VARIABLE;
                    break;
                }
                this.m_tokenType = TokenType.ERROR_TOKEN;
                break;
            }
            case 63: {
                this.appendToToken(this.m_currentCodePoint);
                this.nextCodePoint();
                if (this.readCodePoint(TurtleSyntax.PN_CHARS_U_NUM)) {
                    while (this.readCodePoint(TurtleSyntax.PN_CHARS_VAR2)) {
                    }
                    this.m_tokenType = TokenType.VARIABLE;
                    break;
                }
                this.m_tokenType = TokenType.NON_SYMBOL;
                break;
            }
            default: {
                this.m_tokenType = TokenType.SYMBOL;
                if (this.readCodePoint(TurtleSyntax.PN_CHARS_BASE)) {
                    this.readTokenWithDots(TurtleSyntax.PN_CHARS);
                }
                if (this.readCodePoint(58)) {
                    if (this.m_tokenBuffer.length() == 1 && this.readCodePoint(45)) {
                        this.m_tokenType = TokenType.NON_SYMBOL;
                        break;
                    }
                    if (this.readCodePoint(TurtleSyntax.PN_CHARS_U_NUM_COLON) || this.read_PERCENT() || this.read_PN_LOCAL_ESC()) {
                        this.m_tokenType = TokenType.PNAME_LN;
                        while (!this.m_isAtEOF) {
                            if (this.readCodePoint(TurtleSyntax.PN_CHARS_COLON) || this.read_PERCENT() || this.read_PN_LOCAL_ESC()) continue;
                            if (this.m_currentCodePoint != 46) break block0;
                            this.savePosition();
                            int n = 0;
                            while (!this.m_isAtEOF && this.m_currentCodePoint == 46) {
                                this.nextCodePoint();
                                ++n;
                            }
                            if (!this.m_isAtEOF) {
                                int n3;
                                int n4;
                                if (TurtleSyntax.is_PN_CHARS_COLON(this.m_currentCodePoint)) {
                                    n4 = this.m_currentCodePoint;
                                    this.nextCodePoint();
                                    for (n3 = 0; n3 < n; ++n3) {
                                        this.appendToToken(46);
                                    }
                                    this.appendToToken(n4);
                                    this.m_inputSource.stopBuffering();
                                    continue;
                                }
                                if (this.m_currentCodePoint == 37) {
                                    this.nextCodePoint();
                                    if (!this.m_isAtEOF && HEXtoDEC[this.m_currentCodePoint] != -1) {
                                        n4 = this.m_currentCodePoint;
                                        this.nextCodePoint();
                                        if (!this.m_isAtEOF && HEXtoDEC[this.m_currentCodePoint] != -1) {
                                            n3 = this.m_currentCodePoint;
                                            this.nextCodePoint();
                                            for (int i = 0; i < n; ++i) {
                                                this.appendToToken(46);
                                            }
                                            this.appendToToken(37);
                                            this.appendToToken(n4);
                                            this.appendToToken(n3);
                                            this.m_inputSource.stopBuffering();
                                            continue;
                                        }
                                    }
                                } else if (this.m_currentCodePoint == 92) {
                                    this.nextCodePoint();
                                    if (!this.m_isAtEOF && TurtleSyntax.is_PN_LOCAL_ESC(this.m_currentCodePoint)) {
                                        n4 = this.m_currentCodePoint;
                                        this.nextCodePoint();
                                        for (n3 = 0; n3 < n; ++n3) {
                                            this.appendToToken(46);
                                        }
                                        this.appendToToken(92);
                                        this.appendToToken(n4);
                                        this.m_inputSource.stopBuffering();
                                        continue;
                                    }
                                }
                            }
                            this.restorePosition();
                            break block0;
                        }
                        break;
                    }
                    this.m_tokenType = TokenType.PNAME_NS;
                    break;
                }
                this.m_tokenType = this.m_tokenBuffer.length() == 0 ? TokenType.ERROR_TOKEN : TokenType.SYMBOL;
            }
        }
    }

    public void recover() throws IOException {
        while (this.m_tokenType == TokenType.ERROR_TOKEN) {
            if (this.m_isAtEOF) {
                this.m_tokenType = TokenType.EOF_TOKEN;
                continue;
            }
            if (TurtleSyntax.isWhitespace(this.m_currentCodePoint)) {
                this.m_tokenType = TokenType.NO_TOKEN;
                continue;
            }
            this.nextCodePoint();
        }
    }

    public static enum TokenType {
        NO_TOKEN,
        ERROR_TOKEN,
        EOF_TOKEN,
        INTEGER,
        INTEGER_WITH_EXPONENT,
        DECIMAL,
        DECIMAL_WITH_EXPONENT,
        SYMBOL,
        PNAME_NS,
        PNAME_LN,
        LANGUAGE_TAG,
        NON_SYMBOL,
        VARIABLE,
        QUOTED_IRI,
        QUOTED_STRING,
        BLANK_NODE;

    }
}

