/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.io;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class CipherOutputStream
extends OutputStream {
    protected static final int s_headerSize = 2;
    protected final OutputStream m_outputStream;
    protected final Cipher m_cipher;
    protected final int m_cipherBlockSize;
    protected final int m_cipherBlockSizeMinusOne;
    protected final int m_outputBlockSize;
    protected final byte[] m_outputBlock;
    protected int m_dataCurrentIndex;

    public CipherOutputStream(OutputStream outputStream) throws IOException {
        this.m_outputStream = outputStream;
        try {
            this.m_cipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new IOException(generalSecurityException);
        }
        this.m_cipherBlockSize = this.m_cipher.getBlockSize();
        this.m_cipherBlockSizeMinusOne = this.m_cipherBlockSize - 1;
        this.m_outputBlockSize = 65535 / this.m_cipherBlockSize * this.m_cipherBlockSize;
        this.m_outputBlock = new byte[2 + this.m_outputBlockSize];
        this.m_dataCurrentIndex = 2;
    }

    public void initialize(Key key) throws InvalidKeyException, IOException {
        this.m_cipher.init(1, key);
        this.m_outputStream.write(this.m_cipher.getIV());
    }

    protected void writeOutputBlock() throws IOException {
        if (this.m_dataCurrentIndex > 2) {
            int n = this.m_dataCurrentIndex - 2;
            assert (n < 65536);
            this.m_outputBlock[0] = (byte)(n & 0xFF);
            this.m_outputBlock[1] = (byte)(n >> 8 & 0xFF);
            int n2 = (n + this.m_cipherBlockSizeMinusOne) / this.m_cipherBlockSize * this.m_cipherBlockSize;
            try {
                int n3 = this.m_cipher.update(this.m_outputBlock, 2, n2, this.m_outputBlock, 2);
                if (n3 != n2) {
                    throw new IOException("Encryption returned a block of size " + n3 + ", which is different from the padded size of " + n2 + ".");
                }
            }
            catch (ShortBufferException shortBufferException) {
                throw new IOException("Cipher output stream encryption call failed.", shortBufferException);
            }
            this.m_outputStream.write(this.m_outputBlock, 0, 2 + n2);
            this.m_dataCurrentIndex = 2;
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.m_dataCurrentIndex == this.m_outputBlockSize) {
            this.writeOutputBlock();
        }
        this.m_outputBlock[this.m_dataCurrentIndex] = (byte)n;
        ++this.m_dataCurrentIndex;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.m_dataCurrentIndex + n2;
        while (n3 > this.m_outputBlockSize) {
            int n4 = this.m_outputBlockSize - this.m_dataCurrentIndex;
            System.arraycopy(byArray, n, this.m_outputBlock, this.m_dataCurrentIndex, n4);
            n += n4;
            this.m_dataCurrentIndex = this.m_outputBlockSize;
            this.writeOutputBlock();
            n3 = this.m_dataCurrentIndex + (n2 -= n4);
        }
        assert (n3 <= this.m_outputBlockSize);
        System.arraycopy(byArray, n, this.m_outputBlock, this.m_dataCurrentIndex, n2);
        this.m_dataCurrentIndex = n3;
    }

    @Override
    public void flush() throws IOException {
        this.writeOutputBlock();
        this.m_outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.m_outputStream.close();
    }
}

