/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.logic;

import java.util.HashMap;
import java.util.Map;

public enum Datatype {
    INVALID_DATATYPE("INVALID_DATATYPE", 0),
    BLANK_NODE("internal:blank-node", 1),
    IRI_REFERENCE("internal:iri-reference", 2),
    RDFS_LITERAL("http://www.w3.org/2000/01/rdf-schema#Literal", 3),
    XSD_ANY_URI("http://www.w3.org/2001/XMLSchema#anyURI", 4),
    XSD_STRING("http://www.w3.org/2001/XMLSchema#string", 5),
    RDF_PLAIN_LITERAL("http://www.w3.org/1999/02/22-rdf-syntax-ns#PlainLiteral", 6),
    XSD_BOOLEAN("http://www.w3.org/2001/XMLSchema#boolean", 7),
    XSD_DATE_TIME("http://www.w3.org/2001/XMLSchema#dateTime", 8),
    XSD_DATE_TIME_STAMP("http://www.w3.org/2001/XMLSchema#dateTimeStamp", 9),
    XSD_TIME("http://www.w3.org/2001/XMLSchema#time", 10),
    XSD_DATE("http://www.w3.org/2001/XMLSchema#date", 11),
    XSD_G_YEAR_MONTH("http://www.w3.org/2001/XMLSchema#gYearMonth", 12),
    XSD_G_YEAR("http://www.w3.org/2001/XMLSchema#gYear", 13),
    XSD_G_MONTH_DAY("http://www.w3.org/2001/XMLSchema#gMonthDay", 14),
    XSD_G_DAY("http://www.w3.org/2001/XMLSchema#gDay", 15),
    XSD_G_MONTH("http://www.w3.org/2001/XMLSchema#gMonth", 16),
    XSD_DURATION("http://www.w3.org/2001/XMLSchema#duration", 17),
    XSD_YEAR_MONTH_DURATION("http://www.w3.org/2001/XMLSchema#yearMonthDuration", 18),
    XSD_DAY_TIME_DURATION("http://www.w3.org/2001/XMLSchema#dayTimeDuration", 19),
    XSD_DOUBLE("http://www.w3.org/2001/XMLSchema#double", 20),
    XSD_FLOAT("http://www.w3.org/2001/XMLSchema#float", 21),
    XSD_DECIMAL("http://www.w3.org/2001/XMLSchema#decimal", 22),
    XSD_INTEGER("http://www.w3.org/2001/XMLSchema#integer", 23),
    XSD_NON_NEGATIVE_INTEGER("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", 24),
    XSD_NON_POSITIVE_INTEGER("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", 25),
    XSD_NEGATIVE_INTEGER("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", 26),
    XSD_POSITIVE_INTEGER("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", 27),
    XSD_LONG("http://www.w3.org/2001/XMLSchema#long", 28),
    XSD_INT("http://www.w3.org/2001/XMLSchema#int", 29),
    XSD_SHORT("http://www.w3.org/2001/XMLSchema#short", 30),
    XSD_BYTE("http://www.w3.org/2001/XMLSchema#byte", 31),
    XSD_UNSIGNED_LONG("http://www.w3.org/2001/XMLSchema#unsignedLong", 32),
    XSD_UNSIGNED_INT("http://www.w3.org/2001/XMLSchema#unsignedInt", 33),
    XSD_UNSIGNED_SHORT("http://www.w3.org/2001/XMLSchema#unsignedShort", 34),
    XSD_UNSIGNED_BYTE("http://www.w3.org/2001/XMLSchema#unsignedByte", 35);

    private static final Map<String, Datatype> m_iri2Datatype;
    protected final short m_datatypeID;
    protected final String m_iri;

    protected static void registerAdditionalDatatype(String string, String string2) {
        m_iri2Datatype.put(string, m_iri2Datatype.get(string2));
    }

    public static Datatype value(short s) {
        return Datatype.values()[s];
    }

    public static Datatype value(String string) {
        Datatype datatype = m_iri2Datatype.get(string);
        if (datatype == null) {
            throw new RuntimeException("Invalid datatype '" + string + "'.");
        }
        return datatype;
    }

    private Datatype(String string2, int n2) {
        this.m_datatypeID = (short)n2;
        this.m_iri = string2;
    }

    public short getDatatypeID() {
        return this.m_datatypeID;
    }

    public String getIRI() {
        return this.m_iri;
    }

    static {
        m_iri2Datatype = new HashMap<String, Datatype>();
        for (Datatype datatype : Datatype.values()) {
            m_iri2Datatype.put(datatype.getIRI(), datatype);
        }
        Datatype.registerAdditionalDatatype("http://www.w3.org/2001/XMLSchema#normalizedString", "http://www.w3.org/2001/XMLSchema#string");
        Datatype.registerAdditionalDatatype("http://www.w3.org/2001/XMLSchema#token", "http://www.w3.org/2001/XMLSchema#string");
        Datatype.registerAdditionalDatatype("http://www.w3.org/2001/XMLSchema#language", "http://www.w3.org/2001/XMLSchema#string");
        Datatype.registerAdditionalDatatype("http://www.w3.org/2001/XMLSchema#Name", "http://www.w3.org/2001/XMLSchema#string");
        Datatype.registerAdditionalDatatype("http://www.w3.org/2001/XMLSchema#NCName", "http://www.w3.org/2001/XMLSchema#string");
        Datatype.registerAdditionalDatatype("http://www.w3.org/2001/XMLSchema#NMTOKEN", "http://www.w3.org/2001/XMLSchema#string");
    }
}

