/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.client;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import tech.oxfordsemantic.jrdfox.client.BinaryDataStoreFormat;
import tech.oxfordsemantic.jrdfox.client.ComponentInfo;
import tech.oxfordsemantic.jrdfox.client.DataStoreConnection;
import tech.oxfordsemantic.jrdfox.client.DataStoreInfo;
import tech.oxfordsemantic.jrdfox.client.DataStoreOperationStartMonitor;
import tech.oxfordsemantic.jrdfox.client.OfflineRequestResult;
import tech.oxfordsemantic.jrdfox.client.PasswordSpecificationType;
import tech.oxfordsemantic.jrdfox.exceptions.JRDFoxException;

public interface ServerConnection
extends AutoCloseable {
    public static final byte ACCESS_TYPE_NONE = 0;
    public static final byte ACCESS_TYPE_READ = 1;
    public static final byte ACCESS_TYPE_WRITE = 2;
    public static final byte ACCESS_TYPE_GRANT = 4;
    public static final byte ACCESS_TYPE_STAR = -128;

    @Override
    public void close();

    public void interrupt() throws JRDFoxException;

    public String getAgentName() throws JRDFoxException;

    public ServerConnection duplicate() throws JRDFoxException;

    public Map<String, String> getParameters() throws JRDFoxException;

    public String getRDFoxVersion() throws JRDFoxException;

    public String getRDFoxGitSHA() throws JRDFoxException;

    public long[] getMemoryUse() throws JRDFoxException;

    public void setMaxMemoryUse(long var1) throws JRDFoxException;

    public int getNumberOfThreads() throws JRDFoxException;

    public void setNumberOfThreads(int var1) throws JRDFoxException;

    public int getServerVersion() throws JRDFoxException;

    public boolean checkIntegrity(int var1, OutputStream var2) throws JRDFoxException;

    public ComponentInfo getComponentInfo(boolean var1) throws JRDFoxException;

    public Map<String, Optional<DataStoreInfo>> listDataStores() throws JRDFoxException;

    public boolean containsDataStore(String var1) throws JRDFoxException;

    public DataStoreInfo describeDataStore(String var1) throws JRDFoxException;

    public void createDataStore(String var1, Map<String, String> var2) throws JRDFoxException;

    public void loadDataStoreFromBinaryFormat(String var1, InputStream var2, String var3, String var4, Map<String, String> var5) throws JRDFoxException;

    public void loadDataStoreFromBinaryFormat(String var1, File var2, String var3, String var4, Map<String, String> var5) throws JRDFoxException;

    public void saveDataStoreToBinaryFormat(String var1, OutputStream var2, String var3, String var4, BinaryDataStoreFormat var5) throws JRDFoxException;

    public void saveDataStoreToBinaryFormat(String var1, OutputStream var2, String var3, String var4, BinaryDataStoreFormat var5, DataStoreOperationStartMonitor var6) throws JRDFoxException;

    public void saveDataStoreToBinaryFormat(String var1, File var2, String var3, String var4, BinaryDataStoreFormat var5) throws JRDFoxException;

    public void saveDataStoreToBinaryFormat(String var1, File var2, String var3, String var4, BinaryDataStoreFormat var5, DataStoreOperationStartMonitor var6) throws JRDFoxException;

    public void deleteDataStore(String var1) throws JRDFoxException;

    public void deleteDataStore(String var1, DataStoreOperationStartMonitor var2) throws JRDFoxException;

    public boolean isDataStoreOnline(String var1) throws JRDFoxException;

    public boolean bringDataStoreOnline(String var1) throws JRDFoxException;

    public OfflineRequestResult bringDataStoreOffline(String var1) throws JRDFoxException;

    public DataStoreConnection newDataStoreConnection(String var1) throws JRDFoxException;

    public List<String> listRoles() throws JRDFoxException;

    public void createRole(String var1, String var2) throws JRDFoxException;

    public void createRole(String var1, PasswordSpecificationType var2, String var3) throws JRDFoxException;

    public void deleteRole(String var1) throws JRDFoxException;

    public void changeRolePassword(String var1, String var2) throws JRDFoxException;

    public String getRolePasswordHash(String var1) throws JRDFoxException;

    public List<String> listRoleMemberships(String var1) throws JRDFoxException;

    public List<String> listRoleMembers(String var1) throws JRDFoxException;

    public boolean isMemberOf(String var1, String var2) throws JRDFoxException;

    public boolean grantRole(String var1, String var2) throws JRDFoxException;

    public boolean revokeRole(String var1, String var2) throws JRDFoxException;

    public Map<String, Byte> listPrivileges(String var1) throws JRDFoxException;

    public boolean grantPrivileges(String var1, String var2, byte var3) throws JRDFoxException;

    public boolean revokePrivileges(String var1, String var2, byte var3) throws JRDFoxException;
}

