/*
 * Decompiled with CFR 0.152.
 */
package tech.oxfordsemantic.jrdfox.client;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import tech.oxfordsemantic.jrdfox.Prefixes;
import tech.oxfordsemantic.jrdfox.client.CommitProcedureInfo;
import tech.oxfordsemantic.jrdfox.client.ComponentInfo;
import tech.oxfordsemantic.jrdfox.client.Cursor;
import tech.oxfordsemantic.jrdfox.client.DataSourceInfo;
import tech.oxfordsemantic.jrdfox.client.DataSourceTableInfo;
import tech.oxfordsemantic.jrdfox.client.DataStoreOperationStartMonitor;
import tech.oxfordsemantic.jrdfox.client.DeltaQueryAnswerInfo;
import tech.oxfordsemantic.jrdfox.client.DeltaQueryAnswerType;
import tech.oxfordsemantic.jrdfox.client.DeltaQueryEvaluationMode;
import tech.oxfordsemantic.jrdfox.client.DeltaQueryInfo;
import tech.oxfordsemantic.jrdfox.client.ExplanationType;
import tech.oxfordsemantic.jrdfox.client.ImportNotificationMonitor;
import tech.oxfordsemantic.jrdfox.client.ImportResult;
import tech.oxfordsemantic.jrdfox.client.InputSourceFactory;
import tech.oxfordsemantic.jrdfox.client.QueryAnswerMonitor;
import tech.oxfordsemantic.jrdfox.client.ResourceValue;
import tech.oxfordsemantic.jrdfox.client.RuleInfo;
import tech.oxfordsemantic.jrdfox.client.StatementResult;
import tech.oxfordsemantic.jrdfox.client.StatisticsInfo;
import tech.oxfordsemantic.jrdfox.client.TransactionState;
import tech.oxfordsemantic.jrdfox.client.TransactionType;
import tech.oxfordsemantic.jrdfox.client.TupleTableInfo;
import tech.oxfordsemantic.jrdfox.client.UpdateType;
import tech.oxfordsemantic.jrdfox.exceptions.JRDFoxException;
import tech.oxfordsemantic.jrdfox.logic.datalog.Rule;
import tech.oxfordsemantic.jrdfox.logic.datalog.TupleTableAtom;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Query;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Statement;
import tech.oxfordsemantic.jrdfox.logic.sparql.statement.Update;

public interface DataStoreConnection
extends AutoCloseable {
    public static final long WAIT_FOREVER = -1L;

    @Override
    public void close();

    public void interrupt() throws JRDFoxException;

    public String getAgentName() throws JRDFoxException;

    public long getLockTimeout() throws JRDFoxException;

    public void setLockTimeout(long var1) throws JRDFoxException;

    public DataStoreOperationStartMonitor getDataStoreOperationStartMonitor() throws JRDFoxException;

    public void setDataStoreOperationStartMonitor(DataStoreOperationStartMonitor var1) throws JRDFoxException;

    public DataStoreConnection duplicate() throws JRDFoxException;

    public String getName() throws JRDFoxException;

    public String getUniqueID() throws JRDFoxException;

    public boolean isPersistent() throws JRDFoxException;

    public Map<String, String> getParameters() throws JRDFoxException;

    public ComponentInfo getComponentInfo(boolean var1) throws JRDFoxException;

    public Map<String, String> getDataStoreProperties() throws JRDFoxException;

    public String getDataStoreProperty(String var1) throws JRDFoxException;

    public boolean setDataStoreProperty(String var1, String var2) throws JRDFoxException;

    public Prefixes getPrefixes() throws JRDFoxException;

    public boolean setPrefixes(Prefixes var1) throws JRDFoxException;

    public boolean setPrefix(String var1, String var2) throws JRDFoxException;

    public boolean unsetPrefix(String var1) throws JRDFoxException;

    public Map<String, Optional<DataSourceInfo>> listDataSources() throws JRDFoxException;

    public boolean containsDataSource(String var1) throws JRDFoxException;

    public DataSourceInfo describeDataSource(String var1) throws JRDFoxException;

    public void registerDataSource(String var1, Map<String, String> var2) throws JRDFoxException;

    public void deregisterDataSource(String var1) throws JRDFoxException;

    public List<DataSourceTableInfo> listDataSourceTables(String var1) throws JRDFoxException;

    public boolean containsDataSourceTable(String var1, String var2) throws JRDFoxException;

    public DataSourceTableInfo describeDataSourceTable(String var1, String var2) throws JRDFoxException;

    public ResourceValue[][] getDataSourceTableData(String var1, String var2, int var3) throws JRDFoxException;

    public Map<String, Optional<TupleTableInfo>> listTupleTables() throws JRDFoxException;

    public boolean containsTupleTable(String var1) throws JRDFoxException;

    public TupleTableInfo describeTupleTable(String var1) throws JRDFoxException;

    public void createTupleTable(String var1, Map<String, String> var2) throws JRDFoxException;

    public void deleteTupleTable(String var1) throws JRDFoxException;

    public List<StatisticsInfo> listStatistics() throws JRDFoxException;

    public boolean containsStatistics(String var1) throws JRDFoxException;

    public StatisticsInfo describeStatistics(String var1) throws JRDFoxException;

    public void createStatistics(String var1, Map<String, String> var2) throws JRDFoxException;

    public void deleteStatistics(String var1) throws JRDFoxException;

    public void updateStatistics() throws JRDFoxException;

    public long getDataStoreVersionAfterLastOperation() throws JRDFoxException;

    public long getDataStoreVersion() throws JRDFoxException;

    public long getLastSnapshotDataStoreVersion() throws JRDFoxException;

    public void updateStatistics(String var1) throws JRDFoxException;

    public CommitProcedureInfo getCommitProcedure() throws JRDFoxException;

    public boolean setCommitProcedure(String var1) throws JRDFoxException;

    public boolean setCommitProcedure(List<Update> var1) throws JRDFoxException;

    public Map<String, Optional<DeltaQueryInfo>> listDeltaQueries() throws JRDFoxException;

    public boolean containsDeltaQuery(String var1) throws JRDFoxException;

    public DeltaQueryInfo describeDeltaQuery(String var1) throws JRDFoxException;

    public void registerDeltaQuery(String var1, String var2, String var3, long var4, long var6, long var8) throws JRDFoxException;

    public void registerDeltaQuery(String var1, Query var2, String var3, long var4, long var6, long var8) throws JRDFoxException;

    public void deregisterDeltaQuery(String var1) throws JRDFoxException;

    public void setDeltaQueryEvaluationMode(String var1, DeltaQueryEvaluationMode var2) throws JRDFoxException;

    public List<DeltaQueryAnswerInfo> listDeltaQueryAnswers(Optional<String> var1, Optional<Long> var2, Optional<Long> var3, Optional<DeltaQueryAnswerType> var4) throws JRDFoxException;

    public long deleteDeltaQueryAnswers(Optional<String> var1, Optional<Long> var2, Optional<Long> var3, Optional<DeltaQueryAnswerType> var4) throws JRDFoxException;

    public void exportDeltaQueryAnswer(OutputStream var1, String var2, long var3, DeltaQueryAnswerType var5) throws JRDFoxException;

    public TransactionState getTransactionState() throws JRDFoxException;

    public boolean transactionRequiresRollback() throws JRDFoxException;

    public void beginTransaction(TransactionType var1) throws JRDFoxException;

    public void commitTransaction() throws JRDFoxException;

    public void rollbackTransaction() throws JRDFoxException;

    public void compact() throws JRDFoxException;

    public void clear(int var1) throws JRDFoxException;

    public void clearRulesAxiomsExplicateFacts() throws JRDFoxException;

    public void exportData(OutputStream var1, String var2, Map<String, String> var3) throws JRDFoxException;

    public void exportData(File var1, String var2, Map<String, String> var3) throws JRDFoxException;

    public void exportData(File var1, String var2, String var3, String var4, Map<String, String> var5) throws JRDFoxException;

    public ImportResult importData(UpdateType var1, InputSourceFactory var2, String var3, ImportNotificationMonitor var4) throws JRDFoxException;

    public ImportResult importData(UpdateType var1, Collection<InputSourceFactory> var2, String var3, ImportNotificationMonitor var4) throws JRDFoxException;

    public ImportResult importData(UpdateType var1, File var2) throws JRDFoxException;

    public ImportResult importData(UpdateType var1, String var2) throws JRDFoxException;

    public ImportResult importData(UpdateType var1, InputStream var2) throws JRDFoxException;

    public ImportResult importData(ResourceValue var1, UpdateType var2, InputSourceFactory var3, String var4, ImportNotificationMonitor var5) throws JRDFoxException;

    public ImportResult importData(ResourceValue var1, UpdateType var2, Collection<InputSourceFactory> var3, String var4, ImportNotificationMonitor var5) throws JRDFoxException;

    public ImportResult importData(ResourceValue var1, UpdateType var2, File var3) throws JRDFoxException;

    public ImportResult importData(ResourceValue var1, UpdateType var2, String var3) throws JRDFoxException;

    public ImportResult importData(ResourceValue var1, UpdateType var2, InputStream var3) throws JRDFoxException;

    public ImportResult importAxiomsFromTriples(ResourceValue var1, boolean var2, ResourceValue var3, UpdateType var4, ImportNotificationMonitor var5) throws JRDFoxException;

    public ImportResult importAxiomsFromTriples(ResourceValue var1, boolean var2, ResourceValue var3, UpdateType var4) throws JRDFoxException;

    public List<RuleInfo> listRules() throws JRDFoxException;

    public long addRule(Rule var1) throws JRDFoxException;

    public long addRules(Collection<Rule> var1) throws JRDFoxException;

    public long deleteRule(Rule var1) throws JRDFoxException;

    public long deleteRules(Collection<Rule> var1) throws JRDFoxException;

    public void recompile() throws JRDFoxException;

    public boolean requiresIncrementalReasoning() throws JRDFoxException;

    public void updateMaterialization() throws JRDFoxException;

    public void recomputeMaterialization() throws JRDFoxException;

    public void createExplanation(String var1, int var2, int var3, ExplanationType var4, OutputStream var5) throws JRDFoxException;

    public void createExplanation(TupleTableAtom var1, int var2, int var3, ExplanationType var4, OutputStream var5) throws JRDFoxException;

    public Cursor createCursor(String var1, Map<String, String> var2, int var3) throws JRDFoxException;

    public Cursor createCursor(String var1, Map<String, String> var2) throws JRDFoxException;

    public Cursor createCursor(Query var1, Map<String, String> var2, int var3) throws JRDFoxException;

    public Cursor createCursor(Query var1, Map<String, String> var2) throws JRDFoxException;

    public StatementResult evaluateQuery(String var1, Map<String, String> var2, QueryAnswerMonitor var3) throws JRDFoxException;

    public StatementResult evaluateQuery(Query var1, Map<String, String> var2, QueryAnswerMonitor var3) throws JRDFoxException;

    public StatementResult evaluateUpdate(String var1, Map<String, String> var2) throws JRDFoxException;

    public StatementResult evaluateUpdate(Update var1, Map<String, String> var2) throws JRDFoxException;

    public StatementResult evaluateUpdates(List<Update> var1, Map<String, String> var2) throws JRDFoxException;

    public StatementResult evaluateStatement(String var1, Map<String, String> var2, OutputStream var3, String var4) throws JRDFoxException;

    public StatementResult evaluateStatement(Statement var1, Map<String, String> var2, OutputStream var3, String var4) throws JRDFoxException;

    public StatementResult evaluateStatement(String var1, Map<String, String> var2, File var3, String var4) throws JRDFoxException;

    public StatementResult evaluateStatement(Statement var1, Map<String, String> var2, File var3, String var4) throws JRDFoxException;
}

